/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.datamodels;

import java.awt.Rectangle;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.datamodels.PsoTableModel;

public class TableDruckAlle
extends PsoTableModel {
    private static final long serialVersionUID = 3690474727617935409L;
    private DOMParser parser = new DOMParser();
    private int TabArt = 0;
    private int Modus = 6;
    private boolean Stapelfertig = false;
    public static final int TAB_AZ = 0;
    public static final int TAB_VH = 1;

    public TableDruckAlle(int value) {
        this.TabArt = value;
        this.initColumnNames();
    }

    public void initColumnNames() {
        if (this.TabArt == 0) {
            if (!this.Stapelfertig) {
                if (this.Modus == 5 || !PSAuftrag.isZspPackaging() && PSO.Modus < 3) {
                    this.setDbHeader(PSO.TableDruckAlleASZBN);
                } else {
                    this.setDbHeader(PSO.TableDruckAlleAS);
                }
            } else {
                this.setDbHeader(PSO.TableDruckAlleASStapel);
            }
        } else if (!this.Stapelfertig) {
            this.setDbHeader(PSO.TableDruckAlleVH);
        } else {
            this.setDbHeader(PSO.TableDruckAlleVHStapel);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        int n;
        String result;
        if (!this.Stapelfertig) {
            if (col == 1 && !super.getValueAt(row, col).equals("c/f")) {
                return super.getValueAt(row, col) + " - " + super.getValueAt(row, col + 1);
            }
            if (col > 1) {
                ++col;
            }
            if (col == 6 && !super.getValueAt(row, col).equals("c/f")) {
                return super.getValueAt(row, col) + " " + super.getValueAt(row, ++col);
            }
            if (col > 6) {
                ++col;
            }
        }
        if (!(result = (String)super.getValueAt(row, col)).equals("c/f")) {
            return result;
        }
        if (row == this.lastFetchedRow[0] || row > this.lastFetchedRow[0] && row < this.lastFetchedRow[0] + this.BLOCK_SIZE && this.lastFetchedRow[0] > -1 || row == this.lastFetchedRow[1] || row > this.lastFetchedRow[1] && row < this.lastFetchedRow[1] + this.BLOCK_SIZE && this.lastFetchedRow[1] > -1) {
            return "c/f";
        }
        Rectangle rect = this.TabArt == 0 ? PSO.mainpanel.alleform.getTableAlle().getVisibleRect() : PSO.mainpanel.alleform.getTableAlleV().getVisibleRect();
        int rows = (int)Math.round((double)rect.height / (double)PSO.mainpanel.alleform.getTableAlle().getRowHeight());
        if (rows > 0 && this.BLOCK_SIZE != rows) {
            this.BLOCK_SIZE = rows;
            this.resetTable();
        }
        int rowToGet = this.optimizeRequest(row);
        if (this.TabArt == 0) {
            PSO.cc.SendMessage(247, String.valueOf(rowToGet + 1) + "+" + this.BLOCK_SIZE);
        } else {
            PSO.cc.SendMessage(248, String.valueOf(rowToGet + 1) + "+" + this.BLOCK_SIZE);
        }
        if (this.lastRowIndex == 0) {
            int n2 = this.lastRowIndex;
            n = n2;
            this.lastRowIndex = n2 + 1;
        } else {
            int n3 = this.lastRowIndex;
            n = n3;
            this.lastRowIndex = n3 - 1;
        }
        this.lastFetchedRow[n] = rowToGet;
        return "n/a";
    }

    public void setData(String Data) {
        try {
            this.parser.parse(new InputSource(new StringReader(Data)));
            Document doc = this.parser.getDocument();
            if (PSEnvironment.DEBUG) {
                System.out.println("passing Doc to model...");
            }
            super.setData(doc);
        }
        catch (SAXParseException Ex) {
            if (PSEnvironment.DEBUG) {
                if (PSEnvironment.DEBUG) {
                    System.out.println(String.valueOf(Ex.getLineNumber()));
                }
                Ex.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModus(int value) {
        this.Modus = value;
        this.initColumnNames();
        this.fireTableStructureChanged();
    }

    public void setStapelfertig(boolean value) {
        this.Stapelfertig = value;
        this.initColumnNames();
        this.fireTableStructureChanged();
    }
}

