/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.datamodels;

import java.awt.Rectangle;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.datamodels.PsoTableModel;

public class TableAuswahl
extends PsoTableModel {
    private static final long serialVersionUID = 3617856369781191478L;
    private int Modus = 6;
    private DOMParser parser = new DOMParser();

    public void initColumnNames() {
        switch (this.Modus) {
            case 3: {
                this.setDbHeader(PSAuftrag.getNumTAs() > 1 ? PSO.TableAuswahlZSPTA : PSO.TableAuswahlZSP);
                break;
            }
            case 5: {
                this.setDbHeader(PSAuftrag.getNumTAs() > 1 ? PSO.TableAuswahlZBNTA : PSO.TableAuswahlZSP);
                break;
            }
            case 4: {
                this.setDbHeader(PSAuftrag.getNumTAs() > 1 ? PSO.TableAuswahlBFAHTA : PSO.TableAuswahlBFAH);
                break;
            }
            case 0: {
                this.setDbHeader(PSAuftrag.getNumTAs() > 1 ? PSO.TableAuswahlOrteTA : PSO.TableAuswahlOrte);
            }
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        int n;
        if (row < 0) {
            return "";
        }
        String result = (String)super.getValueAt(row, col);
        if (!result.equals("c/f")) {
            return result;
        }
        if (row == this.lastFetchedRow[0] || row > this.lastFetchedRow[0] && row < this.lastFetchedRow[0] + this.BLOCK_SIZE && this.lastFetchedRow[0] > -1 || row == this.lastFetchedRow[1] || row > this.lastFetchedRow[1] && row < this.lastFetchedRow[1] + this.BLOCK_SIZE && this.lastFetchedRow[1] > -1) {
            return "c/f";
        }
        Rectangle rect = PSO.mainpanel.table_orte.getVisibleRect();
        int rows = (int)Math.round((double)rect.height / (double)PSO.mainpanel.table_orte.getRowHeight());
        if (rows > 0 && this.BLOCK_SIZE != rows) {
            this.BLOCK_SIZE = rows;
            this.resetTable();
        }
        int rowToGet = this.optimizeRequest(row);
        switch (this.Modus) {
            case 0: 
            case 2: {
                PSO.cc.SendMessage(202, String.valueOf(rowToGet + 1) + "+" + this.BLOCK_SIZE);
                break;
            }
            case 4: {
                PSO.cc.SendMessage(208, String.valueOf(rowToGet + 1) + "+" + this.BLOCK_SIZE);
                break;
            }
            case 3: 
            case 5: {
                PSO.cc.SendMessage(207, String.valueOf(rowToGet + 1) + "+" + this.BLOCK_SIZE);
            }
        }
        if (this.lastRowIndex == 0) {
            int n2 = this.lastRowIndex;
            n = n2;
            this.lastRowIndex = n2 + 1;
        } else {
            int n3 = this.lastRowIndex;
            n = n3;
            this.lastRowIndex = n3 - 1;
        }
        this.lastFetchedRow[n] = rowToGet;
        return "n/a";
    }

    public void setBlockSize(int size) {
        this.BLOCK_SIZE = size;
    }

    public void setData(String Data) {
        try {
            this.parser.parse(new InputSource(new StringReader(Data)));
            Document doc = this.parser.getDocument();
            if (PSEnvironment.DEBUG) {
                System.out.println("passing Doc to model...");
            }
            super.setData(doc);
            if (this.isRowInDocument(0, this.getSelectedRow()) || this.isRowInDocument(1, this.getSelectedRow())) {
                this.setSelectedRow(-1);
            }
        }
        catch (SAXParseException Ex) {
            if (PSEnvironment.DEBUG) {
                if (PSEnvironment.DEBUG) {
                    System.out.println(String.valueOf(Ex.getLineNumber()));
                }
                Ex.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setZSPHeader(String value) {
        this.columnHeaders[2] = value;
    }

    public void InitNewModus(int value, String[] header) {
        this.columnHeaders = header;
        this.Modus = value;
        this.maxRecords = 0;
        this.initColumnNames();
        this.fireTableStructureChanged();
    }
}

