/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.zbnimport.log;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.zbnimport.ZbnConstants;
import prospektservice.base.zbnimport.ZbnDataHandler;
import prospektservice.base.zbnimport.log.ZbnLogData;

public class ZbnLogFileWriter
extends FileWriter {
    private String colSep = "\t";
    private ZbnLogData logData;
    private static ResourceBundle props;

    public ZbnLogFileWriter(String fileName, boolean useID, boolean withPeripherals) throws IOException {
        super(fileName);
        this.logData = new ZbnLogData(useID, withPeripherals);
        props = ResourceBundle.getBundle("properties.dlgZBNImportStats", PSUser.getLanguage());
    }

    public void newLine(String sep) throws IOException {
        this.write(sep);
    }

    public void writeToFirstCache(String hhSum, Object entry) {
        this.logData.addData(hhSum, entry.toString());
    }

    public void writeToSecondCache(Object ID, Object entry) {
        this.logData.addPeripheralData(ID, entry);
    }

    public void SetHHSum(String data) {
        this.logData.setHHSum(data);
        ZbnDataHandler.getInstance(false).addZBNDirect("-1");
    }

    public void clearSecondCache() {
        this.logData.clearPeripherals();
    }

    public String[] getAmbiguousEntries() {
        return this.logData.getAmbiguousEntries();
    }

    public void reassignZbn(String zbn, String src) {
        this.logData.reassignZbToSource(zbn, src);
    }

    public void combineCaches() throws IOException {
        String hhSum = "";
        String[] toWrite = this.logData.getFormattedData();
        int i = 0;
        while (i < toWrite.length) {
            this.write(toWrite[i]);
            this.newLine(ZbnConstants.lineSep);
            ++i;
        }
        hhSum = PSEnvironment.formatLongToGermanLocale(this.logData.getHHSum());
        String hhTxt = "";
        switch (PSO.mainpanel.AE.postwurfan) {
            case 0: {
                hhTxt = props.getString("HHSum");
                break;
            }
            case 1: {
                hhTxt = props.getString("HHTpSum");
                break;
            }
            case 3: {
                hhTxt = props.getString("HHAllSum");
            }
        }
        this.write(String.valueOf(hhTxt) + hhSum);
        this.logData.clearAll();
    }

    public void flushFile() throws IOException {
        this.flush();
        this.close();
    }

    public void recalcHH() {
        this.logData.recalcHouseholdData();
    }

    public int getHHForZb(String zbn) {
        return this.logData.getHHForZb(zbn);
    }

    public void setLogEntgelt(boolean flag) {
        this.logData.setLogEntgelt(flag);
    }

    public int getHHUpdateCnt() {
        return this.logData.getHhUpdateCnt();
    }
}

