/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import prospektservice.PSUser;
import prospektservice.base.progress.ProgressEvent;
import prospektservice.base.progress.ProgressListener;

public abstract class ProgressPanel
extends JPanel {
    public static boolean DEBUG_MessageEnabled = true;
    protected ProgressPanel ppInstance;
    public ProgressListener ppListener = null;
    protected JProgressBar progressBar;
    protected int currentProgressMaximum = 0;
    protected final int progressStep = 1;
    private Timer progressTimer;
    private Timer currentDurationTimer;
    protected int progressStepDuration = 1000;
    protected int currentSecondsDuration = 0;
    protected int remainSecondsDuration = 0;
    protected long startSeconds = 0L;
    protected boolean isProgressMessagesVisible = true;
    protected JPanel progressMessages;
    protected JLabel leftMessageContent;
    protected JLabel rightMessageContent;

    public ProgressPanel(int maxValue, int stepDuration, boolean isMessagesVisible) {
        super(new GridLayout(2, 0));
        this.currentProgressMaximum = maxValue;
        this.progressStepDuration = stepDuration;
        this.isProgressMessagesVisible = isMessagesVisible;
        Calendar rightNow = Calendar.getInstance();
        this.startSeconds = rightNow.getTime().getTime();
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.progressBar = new JProgressBar(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setAlignmentX(0.5f);
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(maxValue);
        progressPanel.add((Component)this.progressBar, "Center");
        this.add(progressPanel);
        this.progressMessages = new JPanel(new GridLayout(0, 4));
        this.progressMessages.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        if (this.isProgressMessagesVisible) {
            String leftMessageTitleText = "";
            String rightMessageTitleText = "";
            try {
                ResourceBundle localProperty = ResourceBundle.getBundle("properties.ProgressPanel", PSUser.getLanguage());
                leftMessageTitleText = localProperty.getString("LeftMessageTitle");
                rightMessageTitleText = localProperty.getString("RightMessageTitle");
            }
            catch (MissingResourceException ex) {
                this.printDebugMessage("Konstruktor", ex.getMessage());
            }
            JLabel leftMessageTitle = new JLabel(leftMessageTitleText);
            leftMessageTitle.setHorizontalAlignment(4);
            this.progressMessages.add(leftMessageTitle);
            this.leftMessageContent = new JLabel();
            this.leftMessageContent.setHorizontalAlignment(2);
            this.progressMessages.add(this.leftMessageContent);
            JLabel rightMessageTitle = new JLabel(rightMessageTitleText);
            rightMessageTitle.setHorizontalAlignment(4);
            this.progressMessages.add(rightMessageTitle);
            this.rightMessageContent = new JLabel();
            this.rightMessageContent.setHorizontalAlignment(2);
            this.progressMessages.add(this.rightMessageContent);
        }
        this.add(this.progressMessages);
        this.progressMessages.setVisible(this.isProgressMessagesVisible);
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        this.ppListener = pl;
    }

    public synchronized void removeProgressListener() {
        this.ppListener = null;
    }

    public void finalize() {
        this.ppListener = null;
        this.progressTimer = null;
        this.currentDurationTimer = null;
    }

    public int getProgressMaximum() {
        return this.progressBar.getMaximum();
    }

    public int getProgressValue() {
        return this.progressBar.getValue();
    }

    public int getProgressStepDuration() {
        return this.progressStepDuration;
    }

    public final void printDebugMessage(String methodName, String message) {
        if (DEBUG_MessageEnabled) {
            System.out.println(String.valueOf(this.getClass().getName()) + "." + methodName + "{} ==> " + message);
        }
    }

    public void startProgress() {
        this.ppInstance.setCursor(Cursor.getPredefinedCursor(3));
        if (this.isProgressMessagesVisible) {
            this.startDurationTimer();
        }
        this.startProgressTimer();
        this.fireProgressEvent(101);
    }

    public void breakProgress() {
        if (this.isProgressMessagesVisible) {
            this.breakDurationTimer();
        }
        this.breakProgressTimer();
        this.fireProgressEvent(103);
        this.ppInstance.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void endProgress() {
        if (this.isProgressMessagesVisible) {
            this.breakDurationTimer();
        }
        this.endProgressTimer();
        this.progressBar.setValue(this.currentProgressMaximum);
        this.fireProgressEvent(104);
        this.ppInstance.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void restartProgress() {
        this.breakProgressTimer();
        this.ppInstance.setCursor(Cursor.getPredefinedCursor(3));
        if (this.isProgressMessagesVisible) {
            this.restartDurationTimer();
        }
        this.restartProgressTimer();
    }

    protected void fireProgressEvent(int id) {
        if (this.ppListener != null) {
            switch (id) {
                case 101: {
                    this.ppListener.progressStarted(new ProgressEvent(this.ppInstance, id));
                    break;
                }
                case 102: {
                    this.ppListener.progressChanged(new ProgressEvent(this.ppInstance, id));
                    break;
                }
                case 103: {
                    this.ppListener.progressBroken(new ProgressEvent(this.ppInstance, id));
                    break;
                }
                case 104: {
                    this.ppListener.progressEndet(new ProgressEvent(this.ppInstance, id));
                    break;
                }
                case 105: {
                    this.ppListener.progressMaxChanged(new ProgressEvent(this.ppInstance, id));
                    break;
                }
                case 106: {
                    this.ppListener.progressMaxChanged(new ProgressEvent(this.ppInstance, id));
                }
            }
        }
    }

    protected void changeProgressActionPerformed() {
        if (this.progressBar.getValue() < this.currentProgressMaximum) {
            this.changeProgressValue();
        } else {
            this.endProgress();
        }
    }

    protected void changeProgressValue() {
        this.progressBar.setValue(this.progressBar.getValue() + 1);
        this.restartProgressTimer();
        this.fireProgressEvent(102);
    }

    protected void refreshProgressMessages() {
        Calendar rightNow = Calendar.getInstance();
        this.leftMessageContent.setText(" " + this.getHourMinuteSecond((int)((rightNow.getTime().getTime() - this.startSeconds) / 1000L)));
        this.rightMessageContent.setText(" " + this.getHourMinuteSecond(this.remainSecondsDuration));
        this.progressMessages.repaint();
    }

    protected void startProgressTimer() {
        this.progressTimer = new Timer(this.progressStepDuration, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressPanel.this.changeProgressActionPerformed();
            }
        });
        this.progressTimer.start();
    }

    protected void restartProgressTimer() {
        if (this.progressTimer != null) {
            this.progressTimer.restart();
        } else {
            this.startProgressTimer();
        }
    }

    protected void breakProgressTimer() {
        if (this.progressTimer != null) {
            this.progressTimer.stop();
        }
    }

    private void endProgressTimer() {
        if (this.progressTimer != null) {
            this.progressTimer.stop();
            this.progressTimer = null;
        }
    }

    private String getHourMinuteSecond(int seconds) {
        String sec;
        String min = sec = ":00";
        String hour = "0";
        int hourDur = seconds / 3600;
        int minDur = (seconds - hourDur * 3600) / 60;
        int secDur = seconds - hourDur * 3600 - minDur * 60;
        if (hourDur > 0) {
            hour = String.valueOf(hourDur);
        }
        if (minDur > 0) {
            min = ":" + (minDur > 9 ? "" : "0") + String.valueOf(minDur);
        }
        if (secDur > 0) {
            sec = ":" + (secDur > 9 ? "" : "0") + String.valueOf(secDur);
        }
        return String.valueOf(hour) + min + sec;
    }

    private void startDurationTimer() {
        this.currentSecondsDuration = 0;
        this.currentDurationTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ++ProgressPanel.this.currentSecondsDuration;
                --ProgressPanel.this.remainSecondsDuration;
                ProgressPanel.this.refreshProgressMessages();
                if (ProgressPanel.this.remainSecondsDuration > 0) {
                    ProgressPanel.this.currentDurationTimer.restart();
                }
            }
        });
        this.currentDurationTimer.start();
    }

    private void restartDurationTimer() {
        if (this.currentDurationTimer != null) {
            this.currentDurationTimer.restart();
        }
    }

    private void breakDurationTimer() {
        if (this.currentDurationTimer != null) {
            this.currentDurationTimer.stop();
        }
    }
}

