/*
 * Decompiled with CFR 0.152.
 */
package prospektservice;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Provider;
import java.security.Security;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;
import org.jvnet.substance.watermark.SubstanceWatermark;
import prospektservice.PSO;
import prospektservice.PSOConstants;
import prospektservice.PSUser;
import prospektservice.base.PSImageIcon;
import prospektservice.dialog.PSOProgramOptions;
import prospektservice.laf.DPAGTheme;
import prospektservice.laf.PSOColorScheme;

public class PSEnvironment
implements PSOConstants {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator", "/");
    public static final Color xpLightGray;
    public static final Color dpagColor;
    public static final String[] bannedWords;
    public static PrintStream GLOBAL_OUT;
    private static File file;
    public static boolean ortsteilZBNMode;
    public static final boolean teilauftragEnabled = true;
    public static final boolean amEnabled = true;
    public static final boolean zustellTEnabled = false;
    public static final boolean useNewWeightTable = true;
    private static boolean terminalServerMode;
    public static PSImageIcon up;
    public static PSImageIcon down;
    private static String PSCLIENT_PROPERTIES_FILE;
    private static String PSVERSION_PROPERTIES_FILE;
    private static String PS_EXITERROR_FILE;
    public static String PS_EXITERROR_FILE_ENTRY;
    public static short globalAlpha;
    public static int hotkey;
    public static int hkModifiers;
    private static String addressProxy;
    private static String portProxy;
    private static Properties prpPSClient;
    private static Properties prpPSVersion;
    private static File filePropertiesVersion;
    private static File filePropertiesClient;
    private static Locale envLanguage;
    public static int offsetX;
    public static int offsetY;
    private static int connectionSpeed;
    private static Hashtable<String, String> actionDurationTable;
    private static NumberFormat nf;
    private static long startupTimeStamp;
    public static int PrinterHandle;
    private static boolean windowsPlatform;
    private static boolean macosPlatform;
    public static int minZustellTSdg;
    public static Font Arial9;
    public static Font Arial10;
    public static Font Arial10Table;
    public static Font Arial11;
    public static Font arial14;
    public static Font arial15b;
    public static Font arial18b;
    public static Font arial36b;
    public static Font arial16;
    public static boolean ServerActive;
    private static Point desktopSize;
    public static String PLZUnderCursor;
    public static int aktiveKarte;
    public static DefaultComboBoxModel countriesComboModel;
    public static Runtime rt;
    private static long freeSysMem;
    public static PrintJob Printer;
    public static JFrame mainframe;
    public static boolean DEBUG;
    private static boolean isSepaActive;
    private static String palettenFreitext;
    public static boolean MANUALL_PROGRESS;
    public static String DB_HOUSEHOLDS;
    public static String DB_POBOXES;
    public static String DB_POSTAL_REGULATIONS;
    public static String DB_ACCEPTANCE_OFFICES;
    private static Map<String, Integer> sepaCountriesIbanLength;
    private static boolean gpwsClient;
    private static int mwstValue;
    private static int amMandatoryLimit;
    private static boolean amIoError;
    private static boolean hasAbholCost;

    static {
        dpagColor = xpLightGray = new Color(236, 233, 216);
        bannedWords = new String[]{"Zustelltermin", "Terminzustellung"};
        ortsteilZBNMode = false;
        terminalServerMode = false;
        up = new PSImageIcon("images/up.gif");
        down = new PSImageIcon("images/down.gif");
        PSCLIENT_PROPERTIES_FILE = "PSOClient.properties";
        PSVERSION_PROPERTIES_FILE = "PSOVersion.properties";
        PS_EXITERROR_FILE = "exiterr.log";
        PS_EXITERROR_FILE_ENTRY = "PSO RUNNING";
        globalAlpha = (short)96;
        hotkey = 116;
        hkModifiers = 192;
        prpPSClient = null;
        prpPSVersion = null;
        filePropertiesVersion = null;
        filePropertiesClient = null;
        envLanguage = null;
        offsetX = 0;
        offsetY = 0;
        connectionSpeed = 0;
        actionDurationTable = new Hashtable();
        nf = NumberFormat.getInstance(Locale.GERMAN);
        startupTimeStamp = System.currentTimeMillis();
        PrinterHandle = 0;
        windowsPlatform = false;
        macosPlatform = false;
        minZustellTSdg = 250000;
        ServerActive = false;
        desktopSize = null;
        PLZUnderCursor = "0";
        aktiveKarte = -1;
        rt = Runtime.getRuntime();
        freeSysMem = 0L;
        DEBUG = false;
        isSepaActive = true;
        palettenFreitext = "";
        MANUALL_PROGRESS = true;
        DB_HOUSEHOLDS = "";
        DB_POBOXES = "";
        DB_POSTAL_REGULATIONS = "";
        DB_ACCEPTANCE_OFFICES = "";
        gpwsClient = false;
        mwstValue = 19;
        file = new File("");
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            windowsPlatform = true;
        }
        if (osName.startsWith("Mac")) {
            macosPlatform = true;
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (windowsPlatform) {
            Arial11 = new Font("SansSerif", 0, 11);
            Arial10 = new Font("SansSerif", 0, 10);
            Arial10Table = new Font("SansSerif", 0, 10);
            Arial9 = new Font("SansSerif", 0, 9);
            arial14 = new Font("SansSerif", 0, 10);
            arial15b = new Font("SansSerif", 1, 15);
            arial18b = new Font("SansSerif", 1, 12);
            arial36b = new Font("SansSerif", 1, 19);
            arial16 = new Font("SansSerif", 1, 17);
        } else {
            Arial11 = new Font("SansSerif", 0, 10);
            Arial10 = new Font("SansSerif", 0, 9);
            Arial10Table = new Font("SansSerif", 0, 10);
            Arial9 = new Font("SansSerif", 0, 8);
            arial14 = new Font("SansSerif", 0, 9);
            arial15b = new Font("SansSerif", 1, 13);
            arial18b = new Font("SansSerif", 1, 11);
            arial36b = new Font("SansSerif", 1, 18);
            arial16 = new Font("SansSerif", 1, 16);
        }
        UIManager.put("Label.font", new FontUIResource(Arial11));
        UIManager.put("TextField.font", new FontUIResource(Arial11));
        UIManager.put("TextArea.font", new FontUIResource(Arial11));
        UIManager.put("Button.font", new FontUIResource(Arial11));
        UIManager.put("ToggleButton.font", new FontUIResource(Arial11));
        UIManager.put("CheckBox.font", new FontUIResource(Arial11));
        UIManager.put("TabbedPane.font", new FontUIResource(Arial11));
        UIManager.put("Menu.font", new FontUIResource(Arial11));
        UIManager.put("MenuItem.font", new FontUIResource(Arial11));
        UIManager.put("ComboBox.font", new FontUIResource(Arial11));
        UIManager.put("List.font", new FontUIResource(Arial11));
        UIManager.put("RadioButton.font", new FontUIResource(Arial11));
        UIManager.put("RadioButtonMenuItem.font", new FontUIResource(Arial11));
        UIManager.put("TBJButton.font", new FontUIResource(Arial10));
        UIManager.put("Label.foreground", new ColorUIResource(SystemColor.black));
        UIManager.put("TableHeader.font", new FontUIResource(Arial10));
        UIManager.put("Table.font", new FontUIResource(Arial10));
        UIManager.put("PSJTextField.font", new FontUIResource(Arial11));
        UIManager.put("BorderJTextField.font", new FontUIResource(Arial11));
        sepaCountriesIbanLength = new HashMap<String, Integer>();
        sepaCountriesIbanLength.put("BE", 16);
        sepaCountriesIbanLength.put("BG", 22);
        sepaCountriesIbanLength.put("DK", 18);
        sepaCountriesIbanLength.put("DE", 22);
        sepaCountriesIbanLength.put("EE", 20);
        sepaCountriesIbanLength.put("FI", 18);
        sepaCountriesIbanLength.put("FR", 27);
        sepaCountriesIbanLength.put("GR", 27);
        sepaCountriesIbanLength.put("GB", 22);
        sepaCountriesIbanLength.put("IE", 22);
        sepaCountriesIbanLength.put("IS", 26);
        sepaCountriesIbanLength.put("IT", 27);
        sepaCountriesIbanLength.put("HR", 21);
        sepaCountriesIbanLength.put("LV", 21);
        sepaCountriesIbanLength.put("LI", 21);
        sepaCountriesIbanLength.put("LT", 20);
        sepaCountriesIbanLength.put("LU", 20);
        sepaCountriesIbanLength.put("MT", 31);
        sepaCountriesIbanLength.put("MC", 27);
        sepaCountriesIbanLength.put("NL", 18);
        sepaCountriesIbanLength.put("NO", 15);
        sepaCountriesIbanLength.put("AT", 20);
        sepaCountriesIbanLength.put("PL", 28);
        sepaCountriesIbanLength.put("PT", 25);
        sepaCountriesIbanLength.put("RO", 24);
        sepaCountriesIbanLength.put("SE", 24);
        sepaCountriesIbanLength.put("CH", 21);
        sepaCountriesIbanLength.put("SK", 24);
        sepaCountriesIbanLength.put("SI", 19);
        sepaCountriesIbanLength.put("ES", 24);
        sepaCountriesIbanLength.put("CZ", 24);
        sepaCountriesIbanLength.put("HU", 28);
        sepaCountriesIbanLength.put("CY", 28);
        freeSysMem = rt.freeMemory();
    }

    public static void init() {
        try {
            offsetX = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.offsetX", "0"));
            offsetY = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.offsetY", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            minZustellTSdg = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.minZustellT", "250000"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            String path = String.valueOf(PSEnvironment.getPSStdPath()) + "lib/stdflavors";
            File f = new File(path);
            gpwsClient = f.exists();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkTerminalServerMode() {
        if (PSEnvironment.getPSClientProperty("PS.TerminalServerMode", "1").equals("1")) {
            File dir = new File(PSEnvironment.getPSPath());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String stdPropFile = String.valueOf(file.getAbsolutePath()) + FILE_SEPARATOR + PSCLIENT_PROPERTIES_FILE;
            String userPropFile = String.valueOf(PSEnvironment.getPSPath()) + PSCLIENT_PROPERTIES_FILE;
            File f = new File(userPropFile);
            if (!f.exists()) {
                PSEnvironment.copyFile(stdPropFile, userPropFile);
            }
            String stdVersionFile = String.valueOf(file.getAbsolutePath()) + FILE_SEPARATOR + PSVERSION_PROPERTIES_FILE;
            String userVersionFile = String.valueOf(PSEnvironment.getPSPath()) + PSVERSION_PROPERTIES_FILE;
            f = new File(userVersionFile);
            if (!f.exists()) {
                PSEnvironment.copyFile(stdVersionFile, userVersionFile);
            }
            terminalServerMode = true;
            prpPSClient = null;
            prpPSVersion = null;
        }
    }

    public static boolean copyFile(String srcFile, String destFile) {
        boolean result = false;
        try {
            File fSrc = new File(srcFile);
            int len = 32768;
            byte[] buff = new byte[(int)Math.min((long)len, fSrc.length())];
            FileInputStream fis = new FileInputStream(fSrc);
            FileOutputStream fos = new FileOutputStream(destFile);
            while ((len = fis.read(buff)) > 0) {
                fos.write(buff, 0, len);
            }
            fos.flush();
            fos.close();
            fis.close();
            result = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String getPSClientProperty(String value) {
        return PSEnvironment.getPSClientProperty(value, null);
    }

    public static String getPSClientProperty(String value, String defaultValue) {
        if (value == null) {
            return null;
        }
        if (prpPSClient == null) {
            String fileName = String.valueOf(file.getAbsolutePath()) + FILE_SEPARATOR + PSCLIENT_PROPERTIES_FILE;
            if (terminalServerMode) {
                fileName = String.valueOf(PSEnvironment.getPSPath()) + PSCLIENT_PROPERTIES_FILE;
            }
            try {
                filePropertiesClient = new File(fileName);
                FileInputStream fisClient = new FileInputStream(filePropertiesClient);
                prpPSClient = new Properties();
                prpPSClient.load(fisClient);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (prpPSClient == null) {
            return null;
        }
        return prpPSClient.getProperty(value, defaultValue);
    }

    public static String getPSVersionProperty(String value) {
        String version = PSEnvironment.getPSVersionProperty(value, null);
        if (version == null && value.equals("PS.Client.Version")) {
            version = "99";
            PSEnvironment.setPSVersionProperty("PS.Client.Version", version);
        }
        return version;
    }

    public static String getPSVersionProperty(String value, String defaultValue) {
        if (value == null) {
            return null;
        }
        if (prpPSVersion == null) {
            String fileName = String.valueOf(file.getAbsolutePath()) + FILE_SEPARATOR + PSVERSION_PROPERTIES_FILE;
            if (terminalServerMode) {
                fileName = String.valueOf(PSEnvironment.getPSPath()) + PSVERSION_PROPERTIES_FILE;
            }
            try {
                filePropertiesVersion = new File(fileName);
                FileInputStream fisVersion = new FileInputStream(filePropertiesVersion);
                prpPSVersion = new Properties();
                prpPSVersion.load(fisVersion);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (prpPSVersion == null) {
            return null;
        }
        return prpPSVersion.getProperty(value, defaultValue);
    }

    public static boolean isWindowsPlatform() {
        return windowsPlatform;
    }

    public static boolean isMacOSPlatform() {
        return macosPlatform;
    }

    public static void setPSVersionProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        prpPSVersion.put(key, value);
        try {
            FileOutputStream fosVersion = new FileOutputStream(filePropertiesVersion);
            prpPSVersion.store(fosVersion, "Versionen");
            fosVersion.flush();
            fosVersion.close();
            if (PSEnvironment.isMacOSPlatform() && key.equals("PS.Client.Version")) {
                PSEnvironment.updateBundlePList(value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean updateBundlePList(String version) {
        boolean result = false;
        try {
            String key1 = "<key>CFBundleGetInfoString</key>";
            String key2 = "<key>CFBundleShortVersionString</key>";
            String srcPath = String.valueOf(PSEnvironment.getPSStdPath()) + "../../Info.plist";
            File src = new File(srcPath);
            BufferedReader br = new BufferedReader(new FileReader(src));
            String str = "";
            while (br.ready()) {
                str = String.valueOf(str) + br.readLine() + "\n";
            }
            br.close();
            StringBuffer sb = new StringBuffer(str);
            int startPos = sb.indexOf(key1) + key1.length() + 1;
            int endPos = sb.indexOf("</string>", startPos);
            sb.replace(startPos, endPos, "\t<string>Prospektservice Online Version " + version);
            startPos = sb.indexOf(key2) + key2.length() + 1;
            endPos = sb.indexOf("</string>", startPos);
            sb.replace(startPos, endPos, "\t<string>" + version);
            File bak = new File(String.valueOf(srcPath) + ".old");
            if (bak.exists()) {
                bak.delete();
            }
            src.renameTo(bak);
            BufferedWriter bw = new BufferedWriter(new FileWriter(srcPath));
            bw.write(sb.toString());
            bw.flush();
            bw.close();
            result = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void setPSClientProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        prpPSClient.put(key, value);
        try {
            FileOutputStream fosClient = new FileOutputStream(filePropertiesClient);
            prpPSClient.store(fosClient, "Client Einstellungen");
            fosClient.flush();
            fosClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Point getDesktopSize() {
        if (desktopSize == null) {
            desktopSize = new Point();
            Dimension dd = Toolkit.getDefaultToolkit().getScreenSize();
            PSEnvironment.desktopSize.x = dd.width;
            PSEnvironment.desktopSize.y = dd.height;
        }
        return desktopSize;
    }

    public static String getPSPath() {
        String path = "";
        if (PSEnvironment.isMacOSPlatform()) {
            path = String.valueOf(System.getProperty("user.home")) + FILE_SEPARATOR + "Postaktuell-Manager" + FILE_SEPARATOR;
        } else if (PSEnvironment.isWindowsPlatform()) {
            path = String.valueOf(System.getenv("USERPROFILE")) + FILE_SEPARATOR + "Postaktuell-Manager" + FILE_SEPARATOR;
        } else {
            File file = new File("");
            path = file.getAbsolutePath();
            path = String.valueOf(path) + (path.endsWith(FILE_SEPARATOR) ? "" : FILE_SEPARATOR);
        }
        return path;
    }

    public static String getPSStdPath() {
        File file = new File("");
        String path = file.getAbsolutePath();
        path = String.valueOf(path) + (path.endsWith(FILE_SEPARATOR) ? "" : FILE_SEPARATOR);
        return path;
    }

    public static String getPSURL() {
        String newUrl = "file:////" + PSEnvironment.getPSStdPath();
        newUrl = newUrl.replace('\\', '/');
        try {
            URL url = new URL(newUrl);
            return url.toString();
        }
        catch (Throwable ex) {
            return "";
        }
    }

    public static URL getPSURL(String path) {
        String newUrl = "file:////" + PSEnvironment.getPSStdPath() + path;
        newUrl = newUrl.replace('\\', '/');
        try {
            URL url = new URL(newUrl);
            return url;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Locale getEnvironmentLanguage() {
        if (envLanguage == null) {
            switch (PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.Language"))) {
                case 0: {
                    envLanguage = Locale.GERMAN;
                    break;
                }
                case 1: {
                    envLanguage = Locale.ENGLISH;
                    break;
                }
                case 2: {
                    envLanguage = new Locale("tr", "TR");
                    break;
                }
                default: {
                    envLanguage = Locale.GERMAN;
                }
            }
        }
        return envLanguage;
    }

    public static void resetEnvironmentLanguage() {
        envLanguage = null;
    }

    public static int getComponentWidth(String value, JFrame frame, Font font) {
        int result = 0;
        try {
            FontMetrics fm = frame.getGraphics().getFontMetrics(font);
            result = fm.stringWidth(value) + 6;
            fm = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void setDebugMode() {
        String debug = PSEnvironment.getPSClientProperty("PS.Debug", "0");
        if (debug.equals("1")) {
            DEBUG = true;
        }
    }

    public static void setProgressbarMode() {
        int style = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.Autoprogress"), 1);
        if (style == 0) {
            MANUALL_PROGRESS = false;
        }
    }

    public static void printExceptionMessage(Exception ex) {
        if (DEBUG) {
            System.out.println(" E R R O R ==> " + ex.getMessage());
        }
    }

    public static void printDebugMessage(String modulName, String message) {
        if (DEBUG) {
            System.out.println(" " + modulName + " ==> " + message);
        }
    }

    public static boolean isIntern() {
        String res = PSEnvironment.getPSClientProperty("PS.Intern");
        return res.equals("1");
    }

    public static boolean isfreeMemory() {
        long freeMemNow = rt.freeMemory();
        if ((double)(freeSysMem - freeMemNow) > (double)freeSysMem * 0.1) {
            if (DEBUG) {
                System.out.println("SysMem: " + freeSysMem);
            }
            if (DEBUG) {
                System.out.println("FreeMem: " + freeMemNow);
            }
            return true;
        }
        return false;
    }

    public static void manuellfreeMemory() {
        rt.runFinalization();
        System.gc();
        rt.gc();
    }

    public static void freeMemory() {
        if (PSEnvironment.isfreeMemory()) {
            PSEnvironment.manuellfreeMemory();
        }
    }

    public static void setProxy(String ProxyIP, String ProxyPort) {
        addressProxy = ProxyIP;
        portProxy = ProxyPort;
        PSEnvironment.setPSClientProperty("PS.Proxy.Port", ProxyPort);
        PSEnvironment.setPSClientProperty("PS.Proxy.URL", ProxyIP);
    }

    public static String formatZBN(String zbn) {
        String karteZB = "";
        int pos = zbn.indexOf(45);
        if (pos != -1) {
            karteZB = String.valueOf(zbn.substring(pos - 5, pos)) + zbn.substring(pos + 1, zbn.length());
        } else if (DEBUG) {
            System.out.println("formatZBN -> Kein Bindestrich in String enthalten!");
        }
        return karteZB.trim();
    }

    public static int getIntFromString(String intString) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException nfEx) {
            if (DEBUG) {
                System.out.println("getIntFromString -> NumberFormatException");
            }
            return 0;
        }
    }

    public static String getIntValueFromString(String intString) {
        try {
            return String.valueOf(Integer.parseInt(intString));
        }
        catch (NumberFormatException nfEx) {
            if (DEBUG) {
                System.out.println("getIntFromString -> NumberFormatException");
            }
            return "0";
        }
    }

    public static int getIntValue(String value) {
        return PSEnvironment.getIntValue(value, 0);
    }

    public static int getIntValue(String value, int defvalue) {
        int result = defvalue;
        try {
            if (value != null) {
                int pos = 0;
                while ((pos = value.indexOf(".", pos)) > -1) {
                    value = String.valueOf(value.substring(0, pos)) + value.substring(++pos);
                }
                result = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static long getSaveLong(String in, long defaultValue) {
        long result = 0L;
        try {
            result = Long.parseLong(in);
        }
        catch (NumberFormatException nfEx) {
            result = defaultValue;
        }
        return result;
    }

    public static void setApproximateSpeed(String speed) {
        Calendar rightNow = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("mmssSSS");
        String endTime = formatter.format(rightNow.getTime());
        int elapsedTime = (PSEnvironment.getIntValue(endTime.substring(0, 2)) - PSEnvironment.getIntValue(speed.substring(0, 2))) * 60000;
        elapsedTime += (PSEnvironment.getIntValue(endTime.substring(2, 4)) - PSEnvironment.getIntValue(speed.substring(2, 4))) * 1000;
        connectionSpeed = elapsedTime += PSEnvironment.getIntValue(endTime.substring(4, 7)) - PSEnvironment.getIntValue(speed.substring(4, 7));
    }

    public static int getApproximateSpeed() {
        return connectionSpeed;
    }

    public static void setActionDuration(int actionCode, Calendar startCalendar, Calendar stopCalendar) {
        long actionDuration = stopCalendar.getTime().getTime() - startCalendar.getTime().getTime();
        actionDurationTable.put("" + actionCode, "" + actionDuration);
    }

    public static int getActionDuration(int actionCode) {
        String durString = actionDurationTable.get("" + actionCode);
        if (durString != null) {
            return PSEnvironment.getIntValue(durString);
        }
        return -1;
    }

    public static boolean removeActionDuration(int actionCode) {
        String durString = actionDurationTable.get("" + actionCode);
        if (durString != null) {
            actionDurationTable.remove("" + actionCode);
            return true;
        }
        return false;
    }

    public static void logExitError(String err) {
        String errFileDir = "data" + FILE_SEPARATOR + PSUser.getUserID() + FILE_SEPARATOR;
        try {
            File logFileDir = new File(String.valueOf(PSEnvironment.getPSPath()) + errFileDir);
            logFileDir = new File(logFileDir.getCanonicalPath());
            if (!logFileDir.exists()) {
                logFileDir.mkdirs();
            }
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            Calendar calender = Calendar.getInstance();
            Date rightNow = calender.getTime();
            String date = formatter.format(rightNow);
            BufferedWriter errLogWriter = new BufferedWriter(new FileWriter(String.valueOf(PSEnvironment.getPSPath()) + errFileDir + PS_EXITERROR_FILE));
            errLogWriter.write(String.valueOf(err) + ";" + date);
            errLogWriter.newLine();
            long sessionDuration = (System.currentTimeMillis() - startupTimeStamp) / 60000L;
            errLogWriter.write("" + sessionDuration);
            errLogWriter.flush();
            errLogWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String checkForExitError() {
        BufferedReader errLogReader;
        String errFileDir;
        block4: {
            errFileDir = "data" + FILE_SEPARATOR + PSUser.getUserID() + FILE_SEPARATOR;
            try {
                errLogReader = new BufferedReader(new FileReader(String.valueOf(PSEnvironment.getPSPath()) + errFileDir + PS_EXITERROR_FILE));
                if (errLogReader.ready()) break block4;
                return null;
            }
            catch (IOException ioEx) {
                return null;
            }
        }
        String retVal = errLogReader.readLine();
        PSEnvironment.printDebugMessage("PSEnvironment", "ReadLine -> " + retVal);
        int duration = PSEnvironment.getIntValue(errLogReader.readLine());
        int interval = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.Autosave.interval"));
        retVal = String.valueOf(retVal) + (interval < duration ? "|1" : "|0");
        errLogReader.close();
        File errLog = new File(String.valueOf(PSEnvironment.getPSPath()) + errFileDir, PS_EXITERROR_FILE);
        errLog.delete();
        File zbLog = new File(String.valueOf(PSEnvironment.getPSPath()) + errFileDir, "aoui0001");
        if (zbLog.exists()) {
            zbLog.delete();
        }
        return retVal;
    }

    public static void removeExitError() {
        String errFileDir = "data" + FILE_SEPARATOR + PSUser.getUserID() + FILE_SEPARATOR;
        try {
            BufferedReader errLogReader = new BufferedReader(new FileReader(String.valueOf(PSEnvironment.getPSPath()) + errFileDir + PS_EXITERROR_FILE));
            if (errLogReader.ready()) {
                File zbLog;
                String retVal = errLogReader.readLine();
                errLogReader.close();
                if (retVal.startsWith(PS_EXITERROR_FILE_ENTRY)) {
                    File errLog = new File(String.valueOf(PSEnvironment.getPSPath()) + errFileDir, PS_EXITERROR_FILE);
                    errLog.delete();
                }
                if ((zbLog = new File(String.valueOf(PSEnvironment.getPSPath()) + errFileDir, "aoui0001")).exists()) {
                    zbLog.delete();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String formatLongToGermanLocale(long number) {
        String result = "";
        String tmp = String.valueOf(number);
        int i = 0;
        while (i < tmp.length()) {
            if ((tmp.length() - i) % 3 == 0 && i > 0) {
                result = String.valueOf(result) + ".";
            }
            result = String.valueOf(result) + tmp.charAt(i);
            ++i;
        }
        return result;
    }

    public static String Format(String value, String formater) {
        String result = "";
        if (value != null) {
            try {
                ((DecimalFormat)nf).applyPattern(formater);
                result = nf.format(PSEnvironment.getIntValue(value.trim()));
            }
            catch (NumberFormatException nfex) {
                nfex.printStackTrace();
                result = value;
            }
        }
        return result;
    }

    public static String Format(long value, String formater) {
        String result = "";
        ((DecimalFormat)nf).applyPattern(formater);
        result = nf.format(value);
        return result;
    }

    public static long unformatLongStr(String in) {
        long sum = 0L;
        String tmp = "";
        int i = 0;
        while (i < in.length()) {
            if (in.charAt(i) != '.') {
                tmp = String.valueOf(tmp) + in.charAt(i);
            }
            ++i;
        }
        try {
            sum = Long.parseLong(tmp);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sum;
    }

    public static String moneyAsEuroCent(String in) {
        String out = "";
        int i = 0;
        while (i < in.length()) {
            if (in.charAt(i) != '.' && in.charAt(i) != ',') {
                out = String.valueOf(out) + in.charAt(i);
            }
            ++i;
        }
        return out;
    }

    public static boolean isValidHouseNumber(String in) {
        boolean result = false;
        if (PSEnvironment.isNumeric(in)) {
            result = true;
        } else {
            String tmp = in.substring(0, in.length() - 1);
            result = PSEnvironment.isNumeric(tmp);
        }
        if (!result && in.length() > 2) {
            int cntChars = 0;
            char[] chars = in.toCharArray();
            int i = 0;
            while (i < chars.length) {
                result = PSEnvironment.isNumeric(chars[i]);
                if (!result) {
                    ++cntChars;
                }
                ++i;
            }
            result = cntChars < 3;
        }
        return result;
    }

    public static String Format(long value, String formater, boolean leer) {
        String result = "";
        if (value > 0L) {
            ((DecimalFormat)nf).applyPattern(formater);
            result = nf.format(value);
        } else {
            result = leer ? " " : "";
        }
        return result;
    }

    public static String Format(double value, String formater) {
        String result = "";
        ((DecimalFormat)nf).applyPattern(formater);
        result = nf.format(value);
        return result;
    }

    public static String getToken(String value, int tokenId) {
        return PSEnvironment.getToken(value, tokenId, "|");
    }

    public static String getToken(String value, int tokenId, String delemiter) {
        String result = "";
        String tmp = "";
        int counter = 0;
        if (value.indexOf(String.valueOf(delemiter) + delemiter) > 0) {
            int i = 0;
            while (i < value.length()) {
                tmp = String.valueOf(tmp) + value.charAt(i);
                if (String.valueOf(value.charAt(i)).equals(delemiter)) {
                    tmp = String.valueOf(tmp) + " ";
                }
                ++i;
            }
            value = tmp;
        }
        StringTokenizer tokenArray = new StringTokenizer(value, delemiter);
        while (tokenArray.hasMoreTokens()) {
            if (counter == tokenId) {
                result = tokenArray.nextToken().trim();
                break;
            }
            tmp = tokenArray.nextToken();
            ++counter;
        }
        return result;
    }

    public static int getTokenCount(String value) {
        return PSEnvironment.getTokenCount(value, "|");
    }

    public static int getTokenCount(String value, String delemiter) {
        int result = 0;
        String tmp = "";
        StringTokenizer tokenArray = new StringTokenizer(value, delemiter);
        result = tokenArray.countTokens();
        return result;
    }

    public static boolean isNumeric(char value) {
        return PSEnvironment.isNumeric(new String("" + value));
    }

    public static boolean isNumeric(String value) {
        try {
            int test = Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static String stripBlanks(String in) {
        String result = "";
        int pos = 0;
        int lastPos = 0;
        while ((pos = in.indexOf(" ", lastPos)) > -1) {
            result = String.valueOf(result) + in.substring(lastPos, pos);
            lastPos = pos + 1;
        }
        if (lastPos < in.length()) {
            result = String.valueOf(result) + in.substring(lastPos);
        }
        return result;
    }

    public static boolean isSecurePassword(String pw) {
        boolean result = false;
        int MIN_LENGTH = 8;
        int usedCharSpace = 0;
        String[] partialRegexChecks = new String[]{".*[a-z]+.*", ".*[A-Z]+.*", ".*[\\d]+.*", ".*[@#$%!\\?\\+\\-\\{\\}\\[\\]\\(\\)\\*\\|]+.*"};
        int i = 0;
        while (i < partialRegexChecks.length) {
            if (pw.matches(partialRegexChecks[i])) {
                ++usedCharSpace;
            }
            ++i;
        }
        result = pw.length() >= 8 && usedCharSpace >= 3;
        return result;
    }

    public static void localizeFileChooserUI() {
        try {
            ResourceBundle rb = ResourceBundle.getBundle("properties.FileChooser", PSUser.getLanguage());
            UIManager.put("FileChooser.lookInLabelText", rb.getString("lookInLabelText"));
            UIManager.put("FileChooser.filesOfTypeLabelText", rb.getString("filesOfTypeLabelText"));
            UIManager.put("FileChooser.upFolderToolTipText", rb.getString("upFolderToolTipText"));
            UIManager.put("FileChooser.fileNameLabelText", rb.getString("fileNameLabelText"));
            UIManager.put("FileChooser.homeFolderToolTipText", rb.getString("homeFolderToolTipText"));
            UIManager.put("FileChooser.newFolderToolTipText", rb.getString("newFolderToolTipText"));
            UIManager.put("FileChooser.listViewButtonToolTipTextlist", rb.getString("listViewButtonToolTipTextlist"));
            UIManager.put("FileChooser.detailsViewButtonToolTipText", rb.getString("detailsViewButtonToolTipText"));
            UIManager.put("FileChooser.saveButtonText", rb.getString("saveButtonText"));
            UIManager.put("FileChooser.openButtonText", rb.getString("openButtonText"));
            UIManager.put("FileChooser.cancelButtonText", rb.getString("cancelButtonText"));
            UIManager.put("FileChooser.updateButtonText", rb.getString("updateButtonText"));
            UIManager.put("FileChooser.helpButtonText", rb.getString("helpButtonText"));
            UIManager.put("FileChooser.saveButtonToolTipText", rb.getString("saveButtonToolTipText"));
            UIManager.put("FileChooser.openButtonToolTipText", rb.getString("openButtonToolTipText"));
            UIManager.put("FileChooser.cancelButtonToolTipText", rb.getString("cancelButtonToolTipText"));
            UIManager.put("FileChooser.updateButtonToolTipText", rb.getString("updateButtonToolTipText"));
            UIManager.put("FileChooser.helpButtonToolTipText", rb.getString("helpButtonToolTipText"));
        }
        catch (MissingResourceException mrEx) {
            mrEx.printStackTrace();
        }
    }

    public static void setLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        int lfType = 0;
        String tmp = PSEnvironment.getPSClientProperty("PS.LookAndFeel", "");
        if (tmp.length() > 0) {
            lfType = PSEnvironment.getIntValue(tmp);
            PSEnvironment.setLookAndFeel(lfType);
        }
        globalAlpha = (short)PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.AlphaValue", "96"));
        hotkey = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.DeathHotkey", "116"));
        hkModifiers = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.DeathKeyModifiers", "192"));
    }

    public static void setLookAndFeel(int lfType) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String tmp;
        switch (lfType) {
            case 0: {
                UIManager.setLookAndFeel((LookAndFeel)new SubstanceOfficeSilver2007LookAndFeel());
                SubstanceLookAndFeel.setCurrentWatermark((SubstanceWatermark)new SubstanceStripeWatermark());
                DPAGTheme dpagTheme = new DPAGTheme(new PSOColorScheme(), "Dpag Yellow", SubstanceTheme.ThemeKind.BRIGHT);
                SubstanceLookAndFeel.setCurrentTheme((SubstanceTheme)dpagTheme);
                UIManager.put("TextField.selectionBackground", Color.lightGray);
                PopupFactory.setSharedInstance(new PopupFactory());
                break;
            }
            case 1: {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                PSEnvironment.isMacOSPlatform();
                break;
            }
            case 2: {
                try {
                    int selectedSkin = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.Skin"));
                    Skin skin = SkinLookAndFeel.loadThemePack((String)PSOProgramOptions.getThemePack(selectedSkin));
                    SkinLookAndFeel.setSkin((Skin)skin);
                    UIManager.setLookAndFeel((LookAndFeel)new SkinLookAndFeel());
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (lfType < 1 && !PSEnvironment.isMacOSPlatform()) {
            UIManager.put("MenuItem.background", new ColorUIResource(dpagColor));
            UIManager.put("RadioButtonMenuItem.background", new ColorUIResource(dpagColor));
            UIManager.put("Menu.background", new ColorUIResource(dpagColor));
            UIManager.put("MenuBar.background", new ColorUIResource(dpagColor));
            UIManager.put("PopupMenu.background", new ColorUIResource(dpagColor));
            UIManager.put("CheckBox.background", new ColorUIResource(xpLightGray));
            UIManager.put("RadioButton.background", new ColorUIResource(xpLightGray));
            UIManager.put("Panel.background", new ColorUIResource(xpLightGray));
            UIManager.put("OptionPane.background", new ColorUIResource(xpLightGray));
            UIManager.put("Button.background", new ColorUIResource(xpLightGray));
            UIManager.put("TabbedPane.background", new ColorUIResource(xpLightGray));
            UIManager.put("ScrollPane.background", new ColorUIResource(xpLightGray));
            UIManager.put("Viewport.background", new ColorUIResource(xpLightGray));
            UIManager.put("Slider.background", new ColorUIResource(xpLightGray));
        }
        if ((tmp = PSEnvironment.getPSClientProperty("PS.DecoratedFrames", "")).length() > 0 && PSEnvironment.getIntValue(tmp) == 1) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
    }

    public static void storeLookAndFeel(int lfType, boolean decorated) {
        PSEnvironment.setPSClientProperty("PS.LookAndFeel", "" + lfType);
        PSEnvironment.setPSClientProperty("PS.DecoratedFrames", decorated ? "1" : "0");
        JOptionPane.showMessageDialog(null, "Die \u00c4nderungen werden beim n\u00e4chsten Start aktiv.");
    }

    public static String[] tokenStringToStringArray(String tokenStr, String delimiter) {
        boolean lastItemWasDelim = false;
        StringTokenizer t = new StringTokenizer(tokenStr, delimiter, true);
        String[] data = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            String actFieldValue = t.nextToken();
            actFieldValue = PSEnvironment.replace(actFieldValue, "\"", "");
            if (!(actFieldValue = PSEnvironment.replace(actFieldValue, "'", "")).equals(delimiter) || actFieldValue.equals(delimiter) && lastItemWasDelim) {
                data[i++] = actFieldValue.equals(delimiter) ? "" : actFieldValue;
                lastItemWasDelim = actFieldValue.equals(delimiter);
                continue;
            }
            lastItemWasDelim = true;
        }
        if (lastItemWasDelim) {
            data[i++] = "";
        }
        String[] tmp = new String[i];
        System.arraycopy(data, 0, tmp, 0, i);
        return tmp;
    }

    public static void restartPSO(String msg) {
        JOptionPane.showMessageDialog(null, msg);
        Properties sysProps = System.getProperties();
        String cp = sysProps.getProperty("java.class.path");
        try {
            if (PSEnvironment.isWindowsPlatform()) {
                String processStr = "java -cp \"" + cp + "\" -mx128m -ms128m PSOStart";
                Process process = Runtime.getRuntime().exec(processStr);
            } else if (PSEnvironment.isMacOSPlatform()) {
                String[] cmdArray = new String[]{"open", "\"/Applications/Prospektservice Online.app\""};
                Process process = Runtime.getRuntime().exec(cmdArray);
            } else {
                String processStr = "./j2re1.4.2_07/bin/java -cp \"" + cp + "\" -mx128m -ms128m PSOStart";
                Process process = Runtime.getRuntime().exec(processStr);
            }
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Exception of type " + ex.getClass().toString() + " occured!");
        }
    }

    public static void checkServerEntries() {
        if (!PSEnvironment.getPSClientProperty("PS.Server.IP", "").equals("ps1.mailingfactory.de")) {
            PSEnvironment.setPSClientProperty("PS.Server.IP", "ps1.mailingfactory.de");
        }
        if (!PSEnvironment.getPSClientProperty("PS.Server.Port", "").equals("8080")) {
            PSEnvironment.setPSClientProperty("PS.Server.Port", "8080");
        }
        if (!PSEnvironment.getPSClientProperty("PS.UpdateServer.URL", "").equals("ps1.mailingfactory.de")) {
            PSEnvironment.setPSClientProperty("PS.UpdateServer.URL", "ps1.mailingfactory.de");
        }
        if (!PSEnvironment.getPSClientProperty("PS.UpdateServer.Port", "").equals("8080")) {
            PSEnvironment.setPSClientProperty("PS.UpdateServer.Port", "8080");
        }
        if (!PSEnvironment.getPSClientProperty("PS.Server.Servlet", "").equals("PSOServlets/PsoConnection")) {
            PSEnvironment.setPSClientProperty("PS.Server.Servlet", "PSOServlets/PsoConnection");
        }
        if (!PSEnvironment.getPSClientProperty("PS.Server.WorkerServlet", "").equals("PSOServlets/PsoGenericWorker")) {
            PSEnvironment.setPSClientProperty("PS.Server.WorkerServlet", "PSOServlets/PsoGenericWorker");
        }
    }

    public static void checkServerEntriesEinbeck() {
        String newServerName = "prospektservice.deutschepost.de";
        String newServerPort = "80";
        if (!PSEnvironment.getPSClientProperty("PS.Server.IP", "").equals(newServerName)) {
            PSEnvironment.setPSClientProperty("PS.Server.IP", newServerName);
        }
        if (!PSEnvironment.getPSClientProperty("PS.Server.Port", "").equals(newServerPort)) {
            PSEnvironment.setPSClientProperty("PS.Server.Port", newServerPort);
        }
        if (!PSEnvironment.getPSClientProperty("PS.UpdateServer.URL", "").equals(newServerName)) {
            PSEnvironment.setPSClientProperty("PS.UpdateServer.URL", newServerName);
        }
        if (!PSEnvironment.getPSClientProperty("PS.UpdateServer.Port", "").equals(newServerPort)) {
            PSEnvironment.setPSClientProperty("PS.UpdateServer.Port", newServerPort);
        }
    }

    public static String calcPalWeight(int sdg) {
        String result = "";
        int weight = PSO.mainpanel.AE.getGewicht();
        int kgValue = (int)Math.round((double)sdg * (double)weight / 1000.0);
        result = String.valueOf(kgValue) + " kg";
        return result;
    }

    public static String replace(String value, String delete, String insert) {
        String result = "";
        int i = 0;
        while (i < value.length()) {
            result = String.valueOf(value.charAt(i)).equals(delete) ? String.valueOf(result) + insert : String.valueOf(result) + String.valueOf(value.charAt(i));
            ++i;
        }
        return result;
    }

    public static boolean isValidDate(String date) {
        boolean result = false;
        result = PSEnvironment.isValidDate(date, "dd.MM.yyyy HH:mm");
        if (!result) {
            result = PSEnvironment.isValidDate(date, "dd.MM.yyyy HH:mm:ss");
        }
        return result;
    }

    public static boolean isValidDate(String date, String formater) {
        boolean result = false;
        Object testdate = null;
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(formater);
            format.getCalendar().setLenient(false);
            try {
                if (date.toLowerCase().equals(date.toUpperCase())) {
                    result = format.parse(date, new ParsePosition(0)) != null;
                }
            }
            catch (Throwable ep) {
                result = false;
            }
        }
        return result;
    }

    public static String getActDate() {
        return PSEnvironment.getActDate("dd.MM.yyyy");
    }

    public static String getActDate(String strFormat) {
        String result = "";
        try {
            SimpleDateFormat format = new SimpleDateFormat(strFormat);
            result = format.format(new Date());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Date getDate(String value) {
        return PSEnvironment.getDate(value, "dd.MM.yyyy HH:mm");
    }

    public static Date getDate(String value, String formater) {
        Date d = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat(formater);
            format.getCalendar().setLenient(false);
            d = format.parse(value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return d;
    }

    public static String getDate(String startDay, long daysBefore) {
        String result = "";
        long locDays = 0L;
        Date start = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            locDays = daysBefore * 24L;
            locDays *= 3600L;
            locDays *= 1000L;
            start = format.parse(startDay);
            locDays = start.getTime() - locDays;
            result = format.format(new Date(locDays));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isVariableFeiertag(Date date) {
        GregorianCalendar gc7;
        GregorianCalendar gc6;
        GregorianCalendar gc5;
        boolean result = false;
        GregorianCalendar gc1 = new GregorianCalendar();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int J = cal.get(1);
        int a = J % 19;
        int b = J % 4;
        int c = J % 7;
        int m = (8 * (J / 100) + 13) / 25 - 2;
        int s = J / 100 - J / 400 - 2;
        int M = (15 + s - m) % 30;
        int N = (6 + s) % 7;
        int d = (M + 19 * a) % 30;
        int D = d == 29 ? 28 : (d == 28 && a >= 11 ? 27 : d);
        int e = (2 * b + 4 * c + 6 * D + N) % 7;
        GregorianCalendar gc2 = new GregorianCalendar(J, 2, 21);
        GregorianCalendar gc3 = new GregorianCalendar(gc2.get(1), gc2.get(2), gc2.get(5) + D + e + 1);
        int oT = gc3.get(5);
        int oM = gc3.get(2);
        int oJ = gc3.get(1);
        GregorianCalendar gc4 = new GregorianCalendar(oJ, oM, oT - 2);
        if (date.equals(gc4.getTime())) {
            result = true;
        }
        if (date.equals((gc5 = new GregorianCalendar(oJ, oM, oT + 1)).getTime())) {
            result = true;
        }
        if (date.equals((gc6 = new GregorianCalendar(oJ, oM, oT + 39)).getTime())) {
            result = true;
        }
        if (date.equals((gc7 = new GregorianCalendar(oJ, oM, oT + 50)).getTime())) {
            result = true;
        }
        return result;
    }

    public static boolean isFixedFeiertag(Date date) {
        boolean result = false;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        if (gc.get(5) == 1 && gc.get(2) == 0) {
            result = true;
        } else if (gc.get(5) == 1 && gc.get(2) == 4) {
            result = true;
        } else if (gc.get(5) == 3 && gc.get(2) == 9) {
            result = true;
        } else if (gc.get(5) >= 24 && gc.get(5) <= 26 && gc.get(2) == 11) {
            result = true;
        } else if (gc.get(5) == 31 && gc.get(2) == 11) {
            result = true;
        }
        return result;
    }

    public static void setEmergencyDeathHotkey(final int key, final int modifiers) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                KeyEvent keyEvent;
                if (event instanceof KeyEvent && (keyEvent = (KeyEvent)event).getID() == 401 && keyEvent.getKeyCode() == key && (keyEvent.getModifiersEx() & modifiers) == modifiers) {
                    System.exit(0);
                }
                super.dispatchEvent(event);
            }
        });
        if (key != hotkey || modifiers != hkModifiers) {
            hotkey = key;
            hkModifiers = modifiers;
            PSEnvironment.setPSClientProperty("PS.DeathHotkey", "" + hotkey);
            PSEnvironment.setPSClientProperty("PS.DeathKeyModifiers", "" + hkModifiers);
        }
    }

    public static boolean isSepaActive() {
        return isSepaActive;
    }

    public static void setSepaActive(boolean sepaActive) {
        isSepaActive = sepaActive;
    }

    public static boolean getCheckBankAccounts() {
        return PSEnvironment.getPSClientProperty("PS.CheckBankAccounts", "1").equals("1");
    }

    public static String insertUmlaute(String in) {
        String result = in;
        result = result.replaceAll("ae", "\u00e4");
        result = result.replaceAll("oe", "\u00f6");
        result = result.replaceAll("ue", "\u00fc");
        result = result.replaceAll("Ae", "\u00c4");
        result = result.replaceAll("Oe", "\u00d6");
        result = result.replaceAll("Ue", "\u00fc");
        return result;
    }

    public static boolean isCorrectLengthForCountryCode(String cc, int len) {
        boolean result = false;
        Integer expectedLength = sepaCountriesIbanLength.get(cc);
        if (expectedLength != null) {
            result = len == expectedLength;
        }
        return result;
    }

    public static boolean isGpwsClient() {
        return gpwsClient;
    }

    public static void setGpwsClient(boolean gpwsClient) {
        PSEnvironment.gpwsClient = gpwsClient;
    }

    public static int getMwstValue() {
        return mwstValue;
    }

    public static void setMwstValue(int mwstValue) {
        PSEnvironment.mwstValue = mwstValue;
    }

    public static void composeMailAvis(String address) {
        String cmd = "mailto:" + address + "?" + "subject" + "=" + PSEnvironment.urlEncode("ELN-Transportavis") + "&" + "body" + "=" + PSEnvironment.urlEncode("Sehr geehrte Damen und Herren\r\n\r\nanbei die ELN-Transportavis f\u00fcr unsere Verteilung.\r\n\r\nMfG Borat") + "&" + "attach" + "=" + PSEnvironment.urlEncode("F:\\eclipse\\workspace\\PSOEjb\\dokumente\\palavise.pdf");
        try {
            Desktop.getDesktop().mail(new URI(cmd));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return "<encoding error>";
        }
    }

    public static int getAmMandatoryLimit() {
        return amMandatoryLimit;
    }

    public static void setAmMandatoryLimit(int amMandatoryLimit) {
        PSEnvironment.amMandatoryLimit = amMandatoryLimit;
    }

    public static boolean isAmIoError() {
        return amIoError;
    }

    public static void setAmIoError(boolean amIoError) {
        PSEnvironment.amIoError = amIoError;
    }

    public static boolean isHasAbholCost() {
        return hasAbholCost;
    }

    public static void setHasAbholCost(boolean hasAbholCost) {
        PSEnvironment.hasAbholCost = hasAbholCost;
    }

    public static void fixOSXModalWndBug(PSO mainFrame) {
        Thread t = new Thread(() -> {
            while (true) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        Method m = Window.class.getDeclaredMethod("getModalBlocker", new Class[0]);
                        m.setAccessible(true);
                        Dialog dialog = (Dialog)m.invoke((Object)mainFrame, new Object[0]);
                        if (dialog != null && dialog.isVisible()) {
                            dialog.toFront();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                });
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, "Restore-Window-Order-Worker");
        t.setDaemon(true);
        t.start();
    }
}

