/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.topology;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.geotools.geometry.iso.util.algorithm2D.AlgoLine2D;
import org.geotools.geometry.iso.util.topology.BRepEdge2D;
import org.geotools.geometry.iso.util.topology.BRepFace2D;
import org.geotools.geometry.iso.util.topology.BRepNode2D;

public class BdryEdge2D
extends BRepEdge2D {
    protected BRepNode2D p1;
    protected BRepNode2D p2;

    public BdryEdge2D(BRepNode2D p1, BRepNode2D p2, BRepFace2D surfaceRight, BRepFace2D surfaceLeft) {
        super(surfaceRight, surfaceLeft);
        this.p1 = p1;
        this.p2 = p2;
    }

    public BRepNode2D getNodeBeg() {
        return this.p1;
    }

    public BRepNode2D getNodeEnd() {
        return this.p2;
    }

    public void setSimplex(BRepFace2D simplex) {
        if (this.surfaceRight == null) {
            this.surfaceRight = simplex;
        } else {
            this.surfaceLeft = simplex;
        }
    }

    public boolean hasPoint(BRepNode2D p) {
        return this.p1 == p || this.p2 == p;
    }

    public boolean hasSimplex(BRepFace2D s) {
        return this.surfaceRight == s || this.surfaceLeft == s;
    }

    public BRepFace2D getNeighborSimplex(BRepFace2D f) {
        return this.surfaceRight == f ? this.surfaceLeft : this.surfaceRight;
    }

    @Override
    public double getX1() {
        return this.p1.getX();
    }

    @Override
    public double getY1() {
        return this.p1.getY();
    }

    @Override
    public Point2D getP1() {
        return this.p1;
    }

    @Override
    public double getX2() {
        return this.p2.getX();
    }

    @Override
    public double getY2() {
        return this.p2.getY();
    }

    @Override
    public Point2D getP2() {
        return this.p2;
    }

    @Override
    public void setLine(double x1, double y1, double x2, double y2) {
        this.p1.setLocation(x1, y1);
        this.p2.setLocation(x2, y2);
    }

    @Override
    public Rectangle2D getBounds2D() {
        double tmp;
        double x1 = this.getX1();
        double y1 = this.getY1();
        double x2 = this.getX2();
        double y2 = this.getY2();
        if (x2 < x1) {
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if (y2 < y1) {
            tmp = y2;
            y2 = y1;
            y1 = tmp;
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public ArrayList split(double maxSpacing) {
        BdryEdge2D newEdge;
        BdryEdge2D line = this;
        int n = (int)Math.ceil(AlgoLine2D.length(line) / maxSpacing);
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        double deltaX = (x2 - x1) / (double)n;
        double deltaY = (y2 - y1) / (double)n;
        BRepNode2D node1 = line.getNodeBeg();
        ArrayList<BdryEdge2D> result = new ArrayList<BdryEdge2D>();
        result.add(this);
        for (int j = 1; j < n; ++j) {
            BRepNode2D node2 = new BRepNode2D(x1 + deltaX * (double)j, y1 + deltaY * (double)j);
            newEdge = new BdryEdge2D(node1, node2, this.surfaceRight, this.surfaceLeft);
            node2.insertEdge(this);
            node2.insertEdge(newEdge);
            result.add(newEdge);
            node1 = node2;
        }
        newEdge = new BdryEdge2D(node1, line.getNodeEnd(), this.surfaceRight, this.surfaceLeft);
        result.add(newEdge);
        return result;
    }

    public void merge(BdryEdge2D other) {
        BRepNode2D n;
        if (this.p1 == other.p1) {
            n = this.p1;
            BRepNode2D n0 = this.p2;
            BRepNode2D n1 = other.p2;
        } else if (this.p1 == other.p2) {
            n = this.p1;
            BRepNode2D n0 = this.p2;
            BRepNode2D n1 = other.p1;
        } else if (this.p2 == other.p1) {
            n = this.p2;
            BRepNode2D n0 = this.p1;
            BRepNode2D n1 = other.p2;
        } else if (this.p2 == other.p2) {
            n = this.p2;
            BRepNode2D n0 = this.p1;
            BRepNode2D n1 = other.p1;
        } else {
            return;
        }
        if (n.edges.size() != 2) {
            return;
        }
    }
}

