/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.elem2D;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Circle2D {
    private double x = 0.0;
    private double y = 0.0;
    private double radius = 0.0;

    public Circle2D(double centerX, double centerY, double radius) {
        this.x = centerX;
        this.y = centerY;
        this.radius = radius;
    }

    public Circle2D(Point2D pt1, Point2D pt2, Point2D pt3) {
        this.radius = -1.0;
        if (!this.isPerpendicular(pt1, pt2, pt3)) {
            this.CalcCircle(pt1, pt2, pt3);
        } else if (!this.isPerpendicular(pt1, pt3, pt2)) {
            this.CalcCircle(pt1, pt3, pt2);
        } else if (!this.isPerpendicular(pt2, pt1, pt3)) {
            this.CalcCircle(pt2, pt1, pt3);
        } else if (!this.isPerpendicular(pt2, pt3, pt1)) {
            this.CalcCircle(pt2, pt3, pt1);
        } else if (!this.isPerpendicular(pt3, pt2, pt1)) {
            this.CalcCircle(pt3, pt2, pt1);
        } else if (!this.isPerpendicular(pt3, pt1, pt2)) {
            this.CalcCircle(pt3, pt1, pt2);
        } else {
            throw new IllegalArgumentException("The three pts are perpendicular to axis\n");
        }
    }

    private boolean isPerpendicular(Point2D pt1, Point2D pt2, Point2D pt3) {
        double yDelta_a = pt2.getY() - pt1.getY();
        double xDelta_a = pt2.getX() - pt1.getX();
        double yDelta_b = pt3.getY() - pt2.getY();
        double xDelta_b = pt3.getX() - pt2.getX();
        if (Math.abs(xDelta_a) <= 1.0E-9 && Math.abs(yDelta_b) <= 1.0E-9) {
            return false;
        }
        return Math.abs(yDelta_a) <= 1.0E-7 || Math.abs(yDelta_b) <= 1.0E-7 || Math.abs(xDelta_a) <= 1.0E-9 || Math.abs(xDelta_b) <= 1.0E-9;
    }

    private double CalcCircle(Point2D pt1, Point2D pt2, Point2D pt3) {
        double yDelta_a = pt2.getY() - pt1.getY();
        double xDelta_a = pt2.getX() - pt1.getX();
        double yDelta_b = pt3.getY() - pt2.getY();
        double xDelta_b = pt3.getX() - pt2.getX();
        if (Math.abs(xDelta_a) <= 1.0E-9 && Math.abs(yDelta_b) <= 1.0E-9) {
            this.x = 0.5 * (pt2.getX() + pt3.getX());
            this.y = 0.5 * (pt1.getY() + pt2.getY());
            this.radius = pt1.distance(this.getCenter());
            return this.radius;
        }
        double aSlope = yDelta_a / xDelta_a;
        double bSlope = yDelta_b / xDelta_b;
        if (Math.abs(aSlope - bSlope) <= 1.0E-9) {
            throw new IllegalArgumentException("The three pts are colinear\n");
        }
        this.x = (aSlope * bSlope * (pt1.getY() - pt3.getY()) + bSlope * (pt1.getX() + pt2.getX()) - aSlope * (pt2.getX() + pt3.getX())) / (2.0 * (bSlope - aSlope));
        this.y = -1.0 * (this.x - (pt1.getX() + pt2.getX()) / 2.0) / aSlope + (pt1.getY() + pt2.getY()) / 2.0;
        this.radius = pt1.distance(this.getCenter());
        return this.radius;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getRadius() {
        return this.radius;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.x, this.y);
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setValues(double x, double y, double radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    public boolean contains(Point2D dp) {
        double dy;
        double dx = this.x - dp.getX();
        return dx * dx + (dy = this.y - dp.getY()) * dy < this.radius * this.radius;
    }

    public Rectangle2D getRectangle() {
        return new Rectangle2D.Double(this.x - this.radius, this.y - this.radius, 2.0 * this.radius, 2.0 * this.radius);
    }

    public String toString() {
        return "Circle2D: X:" + this.x + " Y:" + this.y + " r:" + this.radius;
    }
}

