/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.index.quadtree;

import org.geotools.geometry.iso.index.quadtree.Key;
import org.geotools.geometry.iso.index.quadtree.NodeBase;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Envelope;
import org.geotools.geometry.iso.util.Assert;

public class Node
extends NodeBase {
    private Envelope env;
    private Coordinate centre;
    private int level;

    public static Node createNode(Envelope env) {
        Key key = new Key(env);
        Node node = new Node(key.getEnvelope(), key.getLevel());
        return node;
    }

    public static Node createExpanded(Node node, Envelope addEnv) {
        Envelope expandEnv = new Envelope(addEnv);
        if (node != null) {
            expandEnv.expandToInclude(node.env);
        }
        Node largerNode = Node.createNode(expandEnv);
        if (node != null) {
            largerNode.insertNode(node);
        }
        return largerNode;
    }

    public Node(Envelope env, int level) {
        this.env = env;
        this.level = level;
        this.centre = new Coordinate();
        this.centre.x = (env.getMinX() + env.getMaxX()) / 2.0;
        this.centre.y = (env.getMinY() + env.getMaxY()) / 2.0;
    }

    public Envelope getEnvelope() {
        return this.env;
    }

    @Override
    protected boolean isSearchMatch(Envelope searchEnv) {
        return this.env.intersects(searchEnv);
    }

    public Node getNode(Envelope searchEnv) {
        int subnodeIndex = Node.getSubnodeIndex(searchEnv, this.centre);
        if (subnodeIndex != -1) {
            Node node = this.getSubnode(subnodeIndex);
            return node.getNode(searchEnv);
        }
        return this;
    }

    public NodeBase find(Envelope searchEnv) {
        int subnodeIndex = Node.getSubnodeIndex(searchEnv, this.centre);
        if (subnodeIndex == -1) {
            return this;
        }
        if (this.subnode[subnodeIndex] != null) {
            Node node = this.subnode[subnodeIndex];
            return node.find(searchEnv);
        }
        return this;
    }

    void insertNode(Node node) {
        Assert.isTrue(this.env == null || this.env.contains(node.env));
        int index = Node.getSubnodeIndex(node.env, this.centre);
        if (node.level == this.level - 1) {
            this.subnode[index] = node;
        } else {
            Node childNode = this.createSubnode(index);
            childNode.insertNode(node);
            this.subnode[index] = childNode;
        }
    }

    private Node getSubnode(int index) {
        if (this.subnode[index] == null) {
            this.subnode[index] = this.createSubnode(index);
        }
        return this.subnode[index];
    }

    private Node createSubnode(int index) {
        double minx = 0.0;
        double maxx = 0.0;
        double miny = 0.0;
        double maxy = 0.0;
        switch (index) {
            case 0: {
                minx = this.env.getMinX();
                maxx = this.centre.x;
                miny = this.env.getMinY();
                maxy = this.centre.y;
                break;
            }
            case 1: {
                minx = this.centre.x;
                maxx = this.env.getMaxX();
                miny = this.env.getMinY();
                maxy = this.centre.y;
                break;
            }
            case 2: {
                minx = this.env.getMinX();
                maxx = this.centre.x;
                miny = this.centre.y;
                maxy = this.env.getMaxY();
                break;
            }
            case 3: {
                minx = this.centre.x;
                maxx = this.env.getMaxX();
                miny = this.centre.y;
                maxy = this.env.getMaxY();
            }
        }
        Envelope sqEnv = new Envelope(minx, maxx, miny, maxy);
        Node node = new Node(sqEnv, this.level - 1);
        return node;
    }
}

