/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.iso.complex.CompositeImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.io.GeometryToString;
import org.geotools.geometry.iso.primitive.CurveBoundaryImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.OrientableCurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveBoundary;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.Primitive;

public class CompositeCurveImpl
extends CompositeImpl<OrientableCurveImpl>
implements CompositeCurve {
    private static final long serialVersionUID = -5774107742557426260L;
    protected EnvelopeImpl envelope = null;

    public CompositeCurveImpl(List<OrientableCurve> generator) {
        super(generator);
        this.checkConsistency();
    }

    private void checkConsistency() {
        Iterator ci = this.elements.iterator();
        if (!ci.hasNext()) {
            throw new IllegalArgumentException("Curve has no elements.");
        }
        CurveImpl c0 = (CurveImpl)ci.next();
        this.envelope = new EnvelopeImpl(c0.getEnvelope());
        while (ci.hasNext()) {
            CurveImpl c1 = (CurveImpl)ci.next();
            this.envelope.expand(c1.getEnvelope());
            DirectPosition startPoint = c1.getStartPoint();
            DirectPosition endPoint = c0.getEndPoint();
            if (!endPoint.equals((Object)startPoint)) {
                throw new IllegalArgumentException("Curve elements are not continous. The end point of a curve has to accord to the start point of the following curve.");
            }
            c0 = c1;
        }
    }

    public List<Primitive> getElements() {
        return (List)super.getElements();
    }

    @Override
    public Set<Complex> createBoundary() {
        Collection generator = this.getElements();
        if (generator == null) {
            throw new IllegalArgumentException("Could not create the boundary of CompositeCurve.");
        }
        HashSet<Complex> result = new HashSet<Complex>();
        result.add(new CurveBoundaryImpl(this.getCoordinateReferenceSystem(), new PointImpl(((CurveImpl)generator.get(0)).getStartPoint()), new PointImpl(((CurveImpl)generator.get(0)).getEndPoint())));
        return result;
    }

    @Override
    public Class getGeneratorClass() {
        return OrientableCurveImpl.class;
    }

    public int getDimension(DirectPositionImpl point) {
        return 1;
    }

    @Override
    public Envelope getEnvelope() {
        return this.envelope;
    }

    public CurveBoundary getBoundary() {
        DirectPosition end;
        DirectPosition start = ((Curve)this.getGenerators().get(0)).getStartPoint();
        if (start.equals((Object)(end = ((Curve)this.getGenerators().get(this.elements.size())).getEndPoint()))) {
            return null;
        }
        return new CurveBoundaryImpl(this.getCoordinateReferenceSystem(), new PointImpl(start), new PointImpl(end));
    }

    public LineStringImpl asLineString() {
        return this.asLineString(0.0, 0.0);
    }

    public LineStringImpl asLineString(double maxSpacing, double maxOffset) {
        Collection primitives = this.getElements();
        if (primitives == null || primitives.isEmpty()) {
            return null;
        }
        LineStringImpl result = ((CurveImpl)primitives.get(0)).asLineString(maxSpacing, maxOffset);
        for (int i = 1; i < primitives.size(); ++i) {
            CurveImpl curve = (CurveImpl)primitives.get(i);
            result = result.merge(curve.asLineString(maxSpacing, maxOffset));
        }
        return result;
    }

    public double getLength() {
        Collection tmpCurves = this.getGenerators();
        if (tmpCurves.isEmpty()) {
            return 0.0;
        }
        double length = 0.0;
        for (int i = 1; i < tmpCurves.size(); ++i) {
            length = DoubleOperation.add(length, ((CurveImpl)tmpCurves.get(i)).length());
        }
        return length;
    }

    public void split(double distance) {
        for (Primitive primitive : this.getElements()) {
            ((CurveImpl)primitive).split(distance);
        }
    }

    @Override
    public CompositeCurveImpl clone() throws CloneNotSupportedException {
        Iterator elementIter = this.elements.iterator();
        ArrayList<OrientableCurve> newElements = new ArrayList<OrientableCurve>();
        while (elementIter.hasNext()) {
            newElements.add((OrientableCurve)((Curve)((Curve)elementIter.next()).clone()));
        }
        return new CompositeCurveImpl((List<OrientableCurve>)newElements);
    }

    public boolean isSimple() {
        return false;
    }

    public CompositeCurve getComposite() {
        return null;
    }

    public int getOrientation() {
        return 0;
    }

    public Curve getPrimitive() {
        return null;
    }

    public Set getContainedPrimitives() {
        return null;
    }

    public Set getContainingPrimitives() {
        return null;
    }

    public Set getComplexes() {
        return null;
    }

    public OrientablePrimitive[] getProxy() {
        return null;
    }

    public List<OrientableCurve> getGenerators() {
        return this.elements;
    }

    @Override
    public int getDimension(DirectPosition point) {
        return 1;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return ((Primitive)this.elements.get(0)).getRepresentativePoint();
    }

    public String toString() {
        return GeometryToString.getString(this);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.envelope == null ? 0 : this.envelope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeCurveImpl other = (CompositeCurveImpl)obj;
        return !(this.envelope == null ? other.envelope != null : !this.envelope.equals(other.envelope));
    }
}

