/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.OptionArgument;
import com.lowagie.toolbox.arguments.PageSizeArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Txt2Pdf
extends AbstractTool {
    static {
        Txt2Pdf.addVersion("$Id: Txt2Pdf.java 3271 2008-04-18 20:39:42Z xlv $");
    }

    public Txt2Pdf() {
        this.menuoptions = 11;
        this.arguments.add(new FileArgument((AbstractTool)this, "srcfile", "The file you want to convert", false));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted text has to be written", true, new PdfFilter()));
        PageSizeArgument oa1 = new PageSizeArgument(this, "pagesize", "Pagesize");
        this.arguments.add(oa1);
        OptionArgument oa2 = new OptionArgument(this, "orientation", "Orientation of the page");
        oa2.addOption("Portrait", "PORTRAIT");
        oa2.addOption("Landscape", "LANDSCAPE");
        this.arguments.add(oa2);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Txt2Pdf", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Txt2Pdf OPENED ===");
    }

    @Override
    public void execute() {
        try {
            Document document;
            Font f;
            String line = null;
            Rectangle pagesize = (Rectangle)this.getValue("pagesize");
            if ("LANDSCAPE".equals(this.getValue("orientation"))) {
                f = FontFactory.getFont("Courier", 10.0f);
                document = new Document(pagesize.rotate(), 36.0f, 9.0f, 36.0f, 36.0f);
            } else {
                f = FontFactory.getFont("Courier", 11.0f);
                document = new Document(pagesize, 72.0f, 36.0f, 36.0f, 36.0f);
            }
            BufferedReader in = new BufferedReader(new FileReader((File)this.getValue("srcfile")));
            PdfWriter.getInstance(document, new FileOutputStream((File)this.getValue("destfile")));
            document.open();
            while ((line = in.readLine()) != null) {
                document.add(new Paragraph(12.0f, line, f));
            }
            document.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        Txt2Pdf tool = new Txt2Pdf();
        if (args.length < 3) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

