/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.rups.io.OutputStreamResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XfaFile
implements OutputStreamResource {
    protected Document xfaDocument;

    public XfaFile(OutputStreamResource resource) throws IOException, DocumentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resource.writeTo(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        SAXReader reader = new SAXReader();
        this.xfaDocument = reader.read((InputStream)bais);
    }

    public Document getXfaDocument() {
        return this.xfaDocument;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.xfaDocument == null) {
            return;
        }
        OutputFormat format = new OutputFormat("   ", true);
        XMLWriter writer = new XMLWriter(os, format);
        writer.write(this.xfaDocument);
    }
}

