/*
 * Decompiled with CFR 0.152.
 */
package com.apple.resources;

import com.apple.resources.MacOSXResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;

class LoadNativeBundleAction
implements PrivilegedExceptionAction<ResourceBundle> {
    String mBaseJavaBundle;
    String mFilenameOverride;

    LoadNativeBundleAction(String string, String string2) {
        this.mBaseJavaBundle = string;
        this.mFilenameOverride = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle run() {
        ResourceBundle resourceBundle = null;
        MacOSXResourceBundle macOSXResourceBundle = null;
        String string = this.mFilenameOverride;
        if (string == null) {
            string = this.mBaseJavaBundle.substring(this.mBaseJavaBundle.lastIndexOf(46) + 1);
        }
        File file = null;
        String string2 = LoadNativeBundleAction.getPathToBundleFile(string);
        InputStream inputStream = null;
        try {
            file = new File(string2);
            inputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(inputStream);
            macOSXResourceBundle = new MacOSXResourceBundle(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Failed to create resources from application bundle.  Using Java-based resources.");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                inputStream = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        resourceBundle = ResourceBundle.getBundle(this.mBaseJavaBundle);
        if (resourceBundle != null && macOSXResourceBundle != null) {
            macOSXResourceBundle.setItsParent(resourceBundle);
            resourceBundle = macOSXResourceBundle;
        }
        return resourceBundle;
    }

    private static native String getPathToBundleFile(String var0);
}

