/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import sun.awt.AppContext;
import sun.java2d.SunGraphics2D;
import sun.security.action.GetPropertyAction;

public class RuntimeOptions {
    public static final int Unknown = -1;
    public static final int Quartz = 1;
    public static final int Sun = 2;
    public static final int OpenGL = 3;
    static final int RendererDefault = 2;
    private static int renderer = -1;
    public static final int OpenGLSwapIntervalDefault = 1;
    public int OpenGLSwapInterval = 1;
    static final int AntialiasingDefault = 1;
    static final int TextAntialiasingDefault = 0;
    private static boolean validAntialiasingProperty = true;
    static final boolean ShowGrowBoxDefault = true;
    public boolean ShowGrowBox;
    static final boolean EnableQ2DXDefault = false;
    public boolean EnableQ2DX = false;
    static final boolean EnableDeferredUpdatesDefault = false;
    public boolean EnableDeferredUpdates = false;
    static final boolean AdjustForJavaDrawingDefault = true;
    public boolean AdjustForJavaDrawing = true;
    static final boolean OptimizeShapesDefault = true;
    public boolean OptimizeShapes = true;
    static final boolean EnableLazyDrawingDefault = true;
    public boolean EnableLazyDrawing = true;
    public static final int EnableLazyDrawingQueueSizeMin = 2;
    public static final int EnableLazyDrawingQueueSizeMultiplier = 5;
    public static final int EnableLazyDrawingQueueSizeMax = (int)Math.pow(5.0, 5.0);
    public static final int EnableLazyDrawingQueueSizeGrowFlush = 2 * (int)Math.pow(5.0, 2.0);
    static final int EnableLazyDrawingQueueSizeDefault = 2;
    public int EnableLazyDrawingQueueSize = 2;
    static final int LazyFlushingFPSDefault = 60;
    public int LazyFlushingFPS = 60;
    public static final int LazyFlushingFPSMin = 1;
    public static final int LazyFlushingFPSMax = Integer.MAX_VALUE;
    static final boolean EnableLazyPixelConversionDefault = true;
    static boolean EnableLazyPixelConversion = true;
    static final boolean RenderLineDefault = true;
    public boolean RenderLine = true;
    static final boolean RenderDrawRectDefault = true;
    public boolean RenderDrawRect = true;
    static final boolean RenderFillRectDefault = true;
    public boolean RenderFillRect = true;
    static final boolean RenderDrawRoundRectDefault = true;
    public boolean RenderDrawRoundRect = true;
    static final boolean RenderFillRoundRectDefault = true;
    public boolean RenderFillRoundRect = true;
    static final boolean RenderDrawOvalDefault = true;
    public boolean RenderDrawOval = true;
    static final boolean RenderFillOvalDefault = true;
    public boolean RenderFillOval = true;
    static final boolean RenderDrawArcDefault = true;
    public boolean RenderDrawArc = true;
    static final boolean RenderFillArcDefault = true;
    public boolean RenderFillArc = true;
    static final boolean RenderDrawPolygonDefault = true;
    public boolean RenderDrawPolygon = true;
    static final boolean RenderFillPolygonDefault = true;
    public boolean RenderFillPolygon = true;
    static final boolean RenderDrawShapeDefault = true;
    public boolean RenderDrawShape = true;
    static final boolean RenderFillShapeDefault = true;
    public boolean RenderFillShape = true;
    static final boolean RenderImageDefault = true;
    public boolean RenderImage = true;
    static final boolean RenderStringDefault = true;
    public boolean RenderString = true;
    static final boolean RenderGlyphsDefault = true;
    public boolean RenderGlyphs = true;
    static final boolean RenderUnicodesDefault = true;
    public boolean RenderUnicodes = true;
    static final boolean AlwaysUseCoreTextDefault = false;
    public boolean AlwaysUseCoreText = false;
    static final boolean FullScreenCaptureAllDisplaysDefault = true;
    public boolean FullScreenCaptureAllDisplays = true;
    static final boolean FullScreenUseFadeDefault = false;
    public boolean FullScreenUseFade = false;
    static final boolean FullScreenHideCursorDefault = false;
    public boolean FullScreenHideCursor = false;
    static final boolean FakeFullScreenDefault = false;
    public boolean FakeFullScreen = false;
    static final int RenderingDefault = 0;
    public int Rendering = 0;
    static final int FractionalMetricsDefault = 1;
    public int FractionalMetrics = 1;
    static final int InterpolationDefault = -1;
    public int Interpolation = -1;
    static final boolean ForceSafeCreationDefault = false;
    public boolean ForceSafeCreation = false;
    static final boolean ForceSafeProgrammaticPositioningDefault = false;
    public boolean ForceSafeProgrammaticPositioning = false;
    static final boolean ForceSafeUserPositioningDefault = false;
    public boolean ForceSafeUserPositioning = false;
    static final boolean EnableColorSystemTrayIconsDefault = false;
    public boolean EnableColorSystemTrayIcons = false;
    boolean EnableColorSystemTrayIconsSet = false;
    static final int AutoreleasePoolThresholdDefault = 1000;
    public int AutoreleasePoolThreshold = 1000;
    static final int AutoreleasePoolThresholdMin = 0;
    static final int AutoreleasePoolThresholdMax = 100000;
    static final boolean UseBrushMetalLookDefault = false;
    public boolean UseBrushMetalLook = false;
    static final boolean UseBrushMetalRoundedDefault = false;
    public boolean UseBrushMetalRounded = false;
    private final Vector<PropertyChangeListener> fPropertyChangeListeners = new Vector();
    public static final String kUseQuartzKey = "apple.awt.graphics.UseQuartz";
    public static final String kUseOpenGLKey = "apple.awt.graphics.UseOpenGL";
    public static final String kOpenGLSwapIntervalKey = "apple.awt.graphics.OpenGLSwapInterval";
    public static final String kEnableQ2DXKey = "apple.awt.graphics.EnableQ2DX";
    public static final String kEnableDeferredUpdatesKey = "apple.awt.graphics.EnableDeferredUpdates";
    public static final String kAdjustForJavaDrawingKey = "apple.awt.graphics.AdjustForJavaDrawing";
    public static final String kOptimizeShapesKey = "apple.awt.graphics.OptimizeShapes";
    public static final String kEnableLazyDrawingKey = "apple.awt.graphics.EnableLazyDrawing";
    public static final String kEnableLazyDrawingQueueSizeKey = "apple.awt.graphics.EnableLazyDrawingQueueSize";
    public static final String kLazyFlushingFPS = "apple.awt.graphics.LazyFlushingFPS";
    public static final String kEnableLazyPixelConversionKey = "apple.awt.graphics.EnableLazyPixelConversion";
    public static final String kUseTwoImageLazyPixelConversionKey = "apple.awt.graphics.UseTwoImageLazyPixelConversion";
    public static final String kUseMPEnabledLazyPixelConversionKey = "apple.awt.graphics.UseMPEnabledLazyPixelConversion";
    public static final String kMPLazyPixelConversionThresholdSizeKey = "apple.awt.graphics.MPLazyPixelConversionThresholdSize";
    public static final String kMPLazyPixelConversionExpireTimeKey = "apple.awt.graphics.MPLazyPixelConversionExpireTime";
    public static final String kRenderLineKey = "apple.awt.graphics.RenderLine";
    public static final String kRenderDrawRectKey = "apple.awt.graphics.RenderDrawRect";
    public static final String kRenderFillRectKey = "apple.awt.graphics.RenderFillRect";
    public static final String kRenderDrawRoundRectKey = "apple.awt.graphics.RenderDrawRoundRect";
    public static final String kRenderFillRoundRectKey = "apple.awt.graphics.RenderFillRoundRect";
    public static final String kRenderDrawOvalKey = "apple.awt.graphics.RenderDrawOval";
    public static final String kRenderFillOvalKey = "apple.awt.graphics.RenderFillOval";
    public static final String kRenderDrawArcKey = "apple.awt.graphics.RenderDrawArc";
    public static final String kRenderFillArcKey = "apple.awt.graphics.RenderFillArc";
    public static final String kRenderDrawPolygonKey = "apple.awt.graphics.RenderDrawPolygon";
    public static final String kRenderFillPolygonKey = "apple.awt.graphics.RenderFillPolygon";
    public static final String kRenderDrawShapeKey = "apple.awt.graphics.RenderDrawShape";
    public static final String kRenderFillShapeKey = "apple.awt.graphics.RenderFillShape";
    public static final String kRenderImageKey = "apple.awt.graphics.RenderImage";
    public static final String kRenderStringKey = "apple.awt.graphics.RenderString";
    public static final String kRenderGlyphsKey = "apple.awt.graphics.RenderGlyphs";
    public static final String kRenderUnicodesKey = "apple.awt.graphics.RenderUnicodes";
    public static final String kAlwaysUseCoreTextKey = "apple.awt.AlwaysUseCoreText";
    public static final String kFullScreenCaptureAllDisplaysKey = "apple.awt.fullscreencapturealldisplays";
    public static final String kFullScreenUseFadeKey = "apple.awt.fullscreenusefade";
    public static final String kFullScreenHideCursorKey = "apple.awt.fullscreenhidecursor";
    public static final String kFakeFullScreenKey = "apple.awt.fakefullscreen";
    public static final String kAntialiasingKey = "apple.awt.antialiasing";
    public static final String kTextAntialiasingKey = "apple.awt.textantialiasing";
    public static final String kTextAntialiasingSwingKey = "swing.aatext";
    public static final String kBrushMetalLookKey = "apple.awt.brushMetalLook";
    public static final String kBrushMetalRoundedKey = "apple.awt.brushMetalRounded";
    public static final String kForceSafeCreationKey = "apple.awt.window.position.forceSafeCreation";
    public static final String kForceSafeUserPositionKey = "apple.awt.window.position.forceSafeUserPositioning";
    public static final String kForceSafeProgrammaticPositionKey = "apple.awt.window.position.forceSafeProgrammaticPositioning";
    public static final String kEnableColorSystemTrayIcons = "apple.awt.SystemTray.EnableColorIcons";
    public static final String kShowGrowBoxKey = "apple.awt.showGrowBox";
    private static MostRecentContextOptionsPair fMostRecentContextOptionsPair = null;
    private static final Map<AppContext, RuntimeOptions> appContext2OptionsHash = Collections.synchronizedMap(new WeakHashMap(2));

    public static synchronized int getRenderer() {
        return RuntimeOptions.getRenderer(null);
    }

    static void setRenderer(int n) {
        renderer = n;
        if (n == 1) {
            System.setProperty(kUseQuartzKey, "true");
            System.setProperty(kUseOpenGLKey, "false");
        }
    }

    public static int getRenderer(SunGraphics2D sunGraphics2D) {
        if (renderer != -1) {
            return renderer;
        }
        String string = System.getProperty(kUseQuartzKey);
        if ("false".equalsIgnoreCase(string)) {
            renderer = 2;
        } else if ("true".equalsIgnoreCase(string)) {
            renderer = 1;
        } else {
            renderer = 2;
            System.setProperty(kUseQuartzKey, renderer == 1 ? "true" : "false");
        }
        string = System.getProperty(kUseOpenGLKey);
        if ("true".equalsIgnoreCase(string)) {
            renderer = 3;
            System.setProperty("swing.defaultlaf", "javax.swing.plaf.metal.MetalLookAndFeel");
        } else {
            System.setProperty(kUseOpenGLKey, renderer == 3 ? "true" : "false");
        }
        return renderer;
    }

    private static Object getAppContextProperty(String string) {
        return AppContext.getAppContext().get(string);
    }

    private static int getAppContextIntegerValue(String string) {
        Integer n = (Integer)RuntimeOptions.getAppContextProperty(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    private static void setAppContextProperty(String string, Object object) {
        AppContext.getAppContext().put(string, object);
    }

    static void setAntialiasing(int n) {
        RuntimeOptions.setAppContextProperty(kAntialiasingKey, n);
    }

    public static synchronized int getAntialiasing() {
        int n = RuntimeOptions.getAppContextIntegerValue(kAntialiasingKey);
        if (n != -1) {
            return n;
        }
        String string = System.getProperty(kAntialiasingKey);
        if ("on".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("off".equalsIgnoreCase(string)) {
            n = 1;
        } else {
            string = RuntimeOptions.getPriviledgedProp("com.apple.macosx.AntiAliasedGraphicsOn");
            if ("true".equalsIgnoreCase(string)) {
                System.err.println("com.apple.macosx.AntiAliasedGraphicsOn has been deprecated. Please switch to apple.awt.Antialiasing.");
                n = 2;
            } else if ("false".equalsIgnoreCase(string)) {
                System.err.println("com.apple.macosx.AntiAliasedGraphicsOn has been deprecated. Please switch to apple.awt.Antialiasing.");
                n = 1;
            } else {
                n = 1;
                validAntialiasingProperty = false;
            }
        }
        RuntimeOptions.setAntialiasing(n);
        return n;
    }

    public static synchronized void setTextAntialiasing(int n) {
        RuntimeOptions.setAppContextProperty(kTextAntialiasingKey, n);
    }

    public static synchronized int getTextAntialiasing() {
        int n = RuntimeOptions.getAppContextIntegerValue(kTextAntialiasingKey);
        if (n != -1) {
            return n;
        }
        RuntimeOptions.getAntialiasing();
        String string = System.getProperty(kTextAntialiasingKey);
        if (string == null) {
            string = RuntimeOptions.getPriviledgedProp(kTextAntialiasingSwingKey);
        }
        if ("on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("off".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            n = 1;
        } else {
            string = RuntimeOptions.getPriviledgedProp("com.apple.macosx.AntiAliasedTextOn");
            if ("true".equalsIgnoreCase(string)) {
                System.err.println("com.apple.macosx.AntiAliasedTextOn has been deprecated. Please switch to apple.awt.TextAntialiasing.");
                n = 2;
            } else if ("false".equalsIgnoreCase(string)) {
                System.err.println("com.apple.macosx.AntiAliasedTextOn has been deprecated. Please switch to apple.awt.TextAntialiasing.");
                n = 1;
            } else {
                n = validAntialiasingProperty ? (RuntimeOptions.getAntialiasing() == 2 ? 2 : 1) : 0;
            }
        }
        RuntimeOptions.setTextAntialiasing(n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Vector<PropertyChangeListener> vector = this.fPropertyChangeListeners;
        synchronized (vector) {
            this.fPropertyChangeListeners.addElement(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Vector<PropertyChangeListener> vector = this.fPropertyChangeListeners;
        synchronized (vector) {
            this.fPropertyChangeListeners.removeElement(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        Vector<PropertyChangeListener> vector = this.fPropertyChangeListeners;
        synchronized (vector) {
            Enumeration<PropertyChangeListener> enumeration = this.fPropertyChangeListeners.elements();
            while (enumeration.hasMoreElements()) {
                PropertyChangeListener propertyChangeListener = enumeration.nextElement();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public static RuntimeOptions getCurrentOptions() {
        AppContext appContext = AppContext.getAppContext();
        RuntimeOptions runtimeOptions = null;
        MostRecentContextOptionsPair mostRecentContextOptionsPair = fMostRecentContextOptionsPair;
        if (mostRecentContextOptionsPair != null && mostRecentContextOptionsPair.fAppContext == appContext) {
            runtimeOptions = mostRecentContextOptionsPair.fOptions;
        } else {
            runtimeOptions = appContext2OptionsHash.get(appContext);
            if (runtimeOptions == null) {
                runtimeOptions = new RuntimeOptions();
                appContext2OptionsHash.put(appContext, runtimeOptions);
            }
            fMostRecentContextOptionsPair = new MostRecentContextOptionsPair(appContext, runtimeOptions);
        }
        return runtimeOptions;
    }

    public void optionsUpdated() {
        this.notifyPropertyChanged(new PropertyChangeEvent(this, "apple.awt.RuntimeOptions", null, null));
    }

    public RuntimeOptions() {
        this.resetOptions();
    }

    static boolean getBooleanValue(String string, boolean bl) {
        String string2 = System.getProperty(string);
        return "true".equalsIgnoreCase(string2) ? true : ("false".equalsIgnoreCase(string2) ? false : bl);
    }

    static int getIntegerValue(String string, int n) {
        String string2 = System.getProperty(string);
        try {
            return string2 == null ? n : Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public void resetOptions() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                RuntimeOptions.this.OpenGLSwapInterval = RuntimeOptions.getIntegerValue(RuntimeOptions.kOpenGLSwapIntervalKey, 1);
                RuntimeOptions.this.EnableQ2DX = RuntimeOptions.getBooleanValue(RuntimeOptions.kEnableQ2DXKey, false);
                RuntimeOptions.this.EnableDeferredUpdates = RuntimeOptions.getBooleanValue(RuntimeOptions.kEnableDeferredUpdatesKey, false);
                RuntimeOptions.this.AdjustForJavaDrawing = RuntimeOptions.getBooleanValue(RuntimeOptions.kAdjustForJavaDrawingKey, true);
                RuntimeOptions.this.OptimizeShapes = RuntimeOptions.getBooleanValue(RuntimeOptions.kOptimizeShapesKey, true);
                RuntimeOptions.this.EnableLazyDrawing = RuntimeOptions.getBooleanValue(RuntimeOptions.kEnableLazyDrawingKey, true);
                if (RuntimeOptions.this.EnableLazyDrawing) {
                    RuntimeOptions.this.EnableLazyDrawingQueueSize = RuntimeOptions.getIntegerValue(RuntimeOptions.kEnableLazyDrawingQueueSizeKey, 2);
                    RuntimeOptions.this.EnableLazyDrawingQueueSize = RuntimeOptions.this.EnableLazyDrawingQueueSize < 2 ? 2 : RuntimeOptions.this.EnableLazyDrawingQueueSize;
                    RuntimeOptions.this.EnableLazyDrawingQueueSize = RuntimeOptions.this.EnableLazyDrawingQueueSize > EnableLazyDrawingQueueSizeMax ? EnableLazyDrawingQueueSizeMax : RuntimeOptions.this.EnableLazyDrawingQueueSize;
                }
                RuntimeOptions.this.LazyFlushingFPS = RuntimeOptions.getIntegerValue(RuntimeOptions.kLazyFlushingFPS, 60);
                RuntimeOptions.this.LazyFlushingFPS = RuntimeOptions.this.LazyFlushingFPS < 1 ? 1 : RuntimeOptions.this.LazyFlushingFPS;
                RuntimeOptions.this.LazyFlushingFPS = RuntimeOptions.this.LazyFlushingFPS > Integer.MAX_VALUE ? Integer.MAX_VALUE : RuntimeOptions.this.LazyFlushingFPS;
                EnableLazyPixelConversion = RuntimeOptions.getBooleanValue(RuntimeOptions.kEnableLazyPixelConversionKey, true);
                RuntimeOptions.this.RenderLine = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderLineKey, true);
                RuntimeOptions.this.RenderDrawRect = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderDrawRectKey, true);
                RuntimeOptions.this.RenderFillRect = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderFillRectKey, true);
                RuntimeOptions.this.RenderDrawRoundRect = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderDrawRoundRectKey, true);
                RuntimeOptions.this.RenderFillRoundRect = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderFillRoundRectKey, true);
                RuntimeOptions.this.RenderDrawOval = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderDrawOvalKey, true);
                RuntimeOptions.this.RenderFillOval = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderFillOvalKey, true);
                RuntimeOptions.this.RenderDrawArc = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderDrawArcKey, true);
                RuntimeOptions.this.RenderFillArc = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderFillArcKey, true);
                RuntimeOptions.this.RenderDrawPolygon = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderDrawPolygonKey, true);
                RuntimeOptions.this.RenderFillPolygon = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderFillPolygonKey, true);
                RuntimeOptions.this.RenderDrawShape = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderDrawShapeKey, true);
                RuntimeOptions.this.RenderFillShape = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderDrawShapeKey, true);
                RuntimeOptions.this.RenderImage = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderImageKey, true);
                RuntimeOptions.this.RenderString = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderStringKey, true);
                RuntimeOptions.this.RenderGlyphs = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderGlyphsKey, true);
                RuntimeOptions.this.RenderUnicodes = RuntimeOptions.getBooleanValue(RuntimeOptions.kRenderUnicodesKey, true);
                RuntimeOptions.this.AlwaysUseCoreText = RuntimeOptions.getBooleanValue(RuntimeOptions.kAlwaysUseCoreTextKey, false);
                RuntimeOptions.this.FullScreenCaptureAllDisplays = RuntimeOptions.getBooleanValue(RuntimeOptions.kFullScreenCaptureAllDisplaysKey, true);
                RuntimeOptions.this.FullScreenUseFade = RuntimeOptions.getBooleanValue(RuntimeOptions.kFullScreenUseFadeKey, false);
                RuntimeOptions.this.FullScreenHideCursor = RuntimeOptions.getBooleanValue(RuntimeOptions.kFullScreenHideCursorKey, false);
                RuntimeOptions.this.FakeFullScreen = RuntimeOptions.getBooleanValue(RuntimeOptions.kFakeFullScreenKey, false);
                String string = null;
                string = System.getProperty("apple.awt.rendering");
                if (string == null) {
                    string = System.getProperty("apple.awt.graphics.rendering");
                }
                RuntimeOptions.this.Rendering = "quality".equalsIgnoreCase(string) ? 2 : ("speed".equalsIgnoreCase(string) ? 1 : 0);
                string = System.getProperty("apple.awt.fractionalmetrics");
                if (string == null) {
                    string = System.getProperty("apple.awt.FractionalMetrics");
                }
                RuntimeOptions.this.FractionalMetrics = "on".equalsIgnoreCase(string) ? 2 : ("off".equalsIgnoreCase(string) ? 1 : 1);
                string = System.getProperty("apple.awt.interpolation");
                if (string == null) {
                    string = System.getProperty("apple.awt.Interpolation");
                }
                RuntimeOptions.this.Interpolation = "nearestneighbor".equalsIgnoreCase(string) ? 0 : ("bilinear".equalsIgnoreCase(string) ? 1 : ("bicubic".equalsIgnoreCase(string) ? 2 : -1));
                RuntimeOptions.this.UseBrushMetalLook = RuntimeOptions.getBooleanValue(RuntimeOptions.kBrushMetalLookKey, false);
                RuntimeOptions.this.UseBrushMetalRounded = RuntimeOptions.this.UseBrushMetalLook && RuntimeOptions.getBooleanValue(RuntimeOptions.kBrushMetalRoundedKey, false);
                RuntimeOptions.this.ForceSafeCreation = RuntimeOptions.getBooleanValue(RuntimeOptions.kForceSafeCreationKey, false);
                RuntimeOptions.this.ForceSafeProgrammaticPositioning = RuntimeOptions.getBooleanValue(RuntimeOptions.kForceSafeProgrammaticPositionKey, false);
                RuntimeOptions.this.ForceSafeUserPositioning = RuntimeOptions.getBooleanValue(RuntimeOptions.kForceSafeUserPositionKey, false);
                RuntimeOptions.this.ShowGrowBox = RuntimeOptions.getBooleanValue(RuntimeOptions.kShowGrowBoxKey, true);
                string = System.getProperty("apple.awt.AutoreleasePoolThreshold");
                if (string != null) {
                    try {
                        RuntimeOptions.this.AutoreleasePoolThreshold = Integer.valueOf(string);
                        RuntimeOptions.this.AutoreleasePoolThreshold = Math.max(0, RuntimeOptions.this.AutoreleasePoolThreshold);
                        RuntimeOptions.this.AutoreleasePoolThreshold = Math.min(100000, RuntimeOptions.this.AutoreleasePoolThreshold);
                    }
                    catch (NumberFormatException numberFormatException) {
                        RuntimeOptions.this.AutoreleasePoolThreshold = 1000;
                    }
                }
                RuntimeOptions.this.notifyPropertyChanged(new PropertyChangeEvent(this, "apple.awt.RuntimeOptions", null, null));
                return null;
            }
        });
    }

    private static void printOption(String string, String string2) {
        RuntimeOptions.printOption(string, null, string2);
    }

    private static void printOption(String string, boolean bl) {
        RuntimeOptions.printOption(string, null, bl);
    }

    private static void printOption(String string, String string2, boolean bl) {
        RuntimeOptions.printOption(string, string2, bl ? "true" : "false");
    }

    private static void printOption(String string, String string2, String string3) {
        System.out.println("Property:'" + string + "'");
        if (string2 != null) {
            System.out.println("Description: " + string2);
        }
        System.out.println("Default Value : " + string3);
        System.out.println("");
    }

    public static void main(String[] stringArray) {
        System.out.println("\n\nMac OS X Java Runtime Options : \n");
        RuntimeOptions.printOption(kUseQuartzKey, "Use Quartz for rendering. ", false);
        RuntimeOptions.printOption(kOpenGLSwapIntervalKey, "Control the swap interval for OpenGL pipeline.Available choices are: 0 (the buffers are swapped with no regard to the vertical refresh rate of the monitor), 1 (the buffers are swapped only during the vertical retrace of the monitor)and n (the buffers are swapped only every n vertical retraces of the monitor).", "1");
        RuntimeOptions.printOption("apple.awt.graphics.ScrollMode", "Override the scroll model in JViewport. Available choices are: BLIT_SCROLL_MODE, BACKINGSTORE_SCROLL_MODE and SIMPLE_SCROLL_MODE.", "BLIT_SCROLL_MODE");
        RuntimeOptions.printOption(kEnableQ2DXKey, "Enable Q2DX.", false);
        RuntimeOptions.printOption(kEnableDeferredUpdatesKey, "Enable Deferred Updates.", false);
        RuntimeOptions.printOption(kOptimizeShapesKey, "Use simple graphics primitives for simple shapes (ex. draw(new Rectangle2D.Float(0, 0, 10, 10)) is mapped to drawRect(0, 0, 10, 10)).", true);
        RuntimeOptions.printOption(kEnableLazyDrawingKey, "Use a queue for graphics primtives (improves graphics performance of rendering simple primtives - lines, rects, arcs, ovals).", true);
        RuntimeOptions.printOption(kEnableLazyDrawingQueueSizeKey, "Controls the size of a queue used by EnableLazyDrawing optimization (in entries, where 1 entry = 4 bytes). One graphics primitive requires ~ 10 entries.", Integer.toString(2));
        RuntimeOptions.printOption(kEnableLazyPixelConversionKey, "Optimize pixel conversion for image formats that are not natively supported on Mac OS X (ex. BufferedImage.TYPE_BYTE_INDEXED)", true);
        RuntimeOptions.printOption(kRenderLineKey, true);
        RuntimeOptions.printOption(kRenderDrawRectKey, true);
        RuntimeOptions.printOption(kRenderFillRectKey, true);
        RuntimeOptions.printOption(kRenderDrawRoundRectKey, true);
        RuntimeOptions.printOption(kRenderFillRoundRectKey, true);
        RuntimeOptions.printOption(kRenderDrawOvalKey, true);
        RuntimeOptions.printOption(kRenderFillOvalKey, true);
        RuntimeOptions.printOption(kRenderDrawArcKey, true);
        RuntimeOptions.printOption(kRenderFillArcKey, true);
        RuntimeOptions.printOption(kRenderDrawPolygonKey, true);
        RuntimeOptions.printOption(kRenderFillPolygonKey, true);
        RuntimeOptions.printOption(kRenderDrawShapeKey, true);
        RuntimeOptions.printOption(kRenderFillShapeKey, true);
        RuntimeOptions.printOption(kRenderImageKey, true);
        RuntimeOptions.printOption(kRenderStringKey, true);
        RuntimeOptions.printOption(kRenderGlyphsKey, true);
        RuntimeOptions.printOption(kRenderUnicodesKey, true);
        RuntimeOptions.printOption(kFullScreenCaptureAllDisplaysKey, "Span full screen across all displays", true);
        RuntimeOptions.printOption(kFullScreenUseFadeKey, "Adds a fade out/in when switching to/from FullScreen", false);
        RuntimeOptions.printOption(kFullScreenHideCursorKey, "Hides the mouse cursor when in full screen mode", false);
        RuntimeOptions.printOption(kFakeFullScreenKey, "Instead of actually having full screen, this places the window full screen behind the title bar, dock, etc. and still uses the other features of full screen", false);
        RuntimeOptions.printOption(kAntialiasingKey, "Controls whether graphic primitives like line, arc, rectangle, etc. are painted with Antialiasing (may be overriden in Graphics2D hints)", "off");
        RuntimeOptions.printOption(kTextAntialiasingKey, "Controls whether text is painted with Antialiasing (may be overriden in Graphics2D hints)", "off");
        RuntimeOptions.printOption(kBrushMetalLookKey, "Changes the window pattern to brush metal instead of the Aqua stripes background (does not effect dialogs)", false);
        RuntimeOptions.printOption(kBrushMetalRoundedKey, "Changes the window to rounded brush metal if present.false");
        RuntimeOptions.printOption(kForceSafeCreationKey, "Ensures all windows are in a usable position on screen when first created", false);
        RuntimeOptions.printOption(kForceSafeProgrammaticPositionKey, "Ensures a window can not be programmatically moved into a position unusable by the user", false);
        RuntimeOptions.printOption(kForceSafeUserPositionKey, "Ensures a window can not be moved by the user into a position which would Render it unusable by the user", false);
        RuntimeOptions.printOption(kEnableColorSystemTrayIcons, "Permits System Tray Icons in the menu bar to use color artwork.false");
        RuntimeOptions.printOption(kShowGrowBoxKey, "Set the resize grow box in the lower right hand corner of a window as visible or invisible for all windows in application", true);
        System.out.println("\n\n");
    }

    private static float getCompatibilityTimeout() {
        float f = 0.5f;
        try {
            String string = RuntimeOptions.getPriviledgedProp("com.apple.eawt.CocoaComponent.CompatibilityMode.timeout");
            if (string != null) {
                f = Float.valueOf(string).floatValue();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return f;
    }

    private static boolean getCompatibilityTimeoutSet() {
        boolean bl = false;
        try {
            String string = RuntimeOptions.getPriviledgedProp("com.apple.eawt.CocoaComponent.CompatibilityMode.timeout");
            if (string != null) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    private static boolean getForcedCompatibilityMode() {
        boolean bl = false;
        try {
            String string = RuntimeOptions.getPriviledgedProp("com.apple.eawt.CocoaComponent.CompatibilityMode");
            if ("always".equals(string)) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    boolean getColorSystemTrayIconsEnabled() {
        if (this.EnableColorSystemTrayIconsSet) {
            return this.EnableColorSystemTrayIcons;
        }
        this.EnableColorSystemTrayIcons = RuntimeOptions.getBooleanPriviledgedProp(kAdjustForJavaDrawingKey, this.AdjustForJavaDrawing);
        this.EnableColorSystemTrayIconsSet = true;
        return this.EnableColorSystemTrayIcons;
    }

    private static String getPriviledgedProp(String string) {
        return AccessController.doPrivileged(new GetPropertyAction(string));
    }

    private static boolean getBooleanPriviledgedProp(String string, boolean bl) {
        String string2 = RuntimeOptions.getPriviledgedProp(string);
        if (string2 == null) {
            return bl;
        }
        return Boolean.parseBoolean(string2);
    }

    static final class MostRecentContextOptionsPair {
        final AppContext fAppContext;
        final RuntimeOptions fOptions;

        MostRecentContextOptionsPair(AppContext appContext, RuntimeOptions runtimeOptions) {
            this.fAppContext = appContext;
            this.fOptions = runtimeOptions;
        }
    }
}

