/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsDevice;
import apple.awt.CPeerSurfaceData;
import apple.awt.ComponentModel;
import apple.awt.OSXBackBuffer;
import apple.awt.OSXSurfaceData;
import apple.awt.RuntimeOptions;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.awt.DisplayChangedListener;
import sun.awt.image.OffScreenImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.security.action.LoadLibraryAction;

public class CGraphicsConfig
extends GraphicsConfiguration
implements DisplayChangedListener {
    protected CGraphicsDevice screen;
    protected int visual;
    protected RenderLoops solidloops;
    private static BufferCapabilities bufferCaps;
    private static ImageCapabilities imageCaps;
    static ColorModel sDefaultColorModelWithAlphaPre;
    static ColorModel sDefaultColorModelWithAlpha;
    static ColorModel sDefaultColorModelNoAlpha;
    private SurfaceType sTypeOrig = null;
    private AffineTransform normalizingTransform;

    static boolean isQuartz() {
        return RuntimeOptions.getRenderer() == 1;
    }

    public static CGraphicsConfig getConfig(CGraphicsDevice cGraphicsDevice, int n) {
        return new CGraphicsConfig(cGraphicsDevice, n);
    }

    public CGraphicsConfig(CGraphicsDevice cGraphicsDevice) {
        this(cGraphicsDevice, 0);
    }

    public CGraphicsConfig(GraphicsDevice graphicsDevice, int n) {
        this.screen = (CGraphicsDevice)graphicsDevice;
        this.visual = n;
        ((CGraphicsDevice)graphicsDevice).addDisplayChangedListener(this);
    }

    @Override
    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public synchronized RenderLoops getSolidLoops(SurfaceType surfaceType) {
        if (this.solidloops == null || this.sTypeOrig != surfaceType) {
            this.solidloops = SurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, surfaceType);
            this.sTypeOrig = surfaceType;
        }
        return this.solidloops;
    }

    @Override
    public BufferedImage createCompatibleImage(int n, int n2) {
        return this.createCompatibleImage(n, n2, CGraphicsConfig.isQuartz() ? 3 : 1);
    }

    @Override
    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return new BufferedImage(n, n2, 1);
            }
            case 2: 
            case 3: {
                return new BufferedImage(n, n2, CGraphicsConfig.isQuartz() ? 3 : 2);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    @Override
    public ColorModel getColorModel() {
        return this.getColorModel(3);
    }

    public ColorModel getDeviceColorModel() {
        return this.screen.getDynamicColorModel();
    }

    @Override
    public ColorModel getColorModel(int n) {
        if (n == 1) {
            return sDefaultColorModelNoAlpha;
        }
        if (n == 3) {
            return CGraphicsConfig.isQuartz() ? sDefaultColorModelWithAlphaPre : sDefaultColorModelWithAlpha;
        }
        if (n == 2) {
            return CGraphicsConfig.isQuartz() ? sDefaultColorModelWithAlphaPre : sDefaultColorModelWithAlpha;
        }
        return null;
    }

    public static ColorModel getTranslucentColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffineTransform getNormalizingTransform() {
        if (this.normalizingTransform != null) {
            return new AffineTransform(this.normalizingTransform);
        }
        CGraphicsConfig cGraphicsConfig = this;
        synchronized (cGraphicsConfig) {
            double d = this.getXResolution() / 72.0;
            double d2 = this.getYResolution() / 72.0;
            this.normalizingTransform = new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
            return new AffineTransform(this.normalizingTransform);
        }
    }

    private native double getXResolution(int var1);

    private native double getYResolution(int var1);

    private double getXResolution() {
        return this.getXResolution(this.screen.getScreen());
    }

    private double getYResolution() {
        return this.getYResolution(this.screen.getScreen());
    }

    public String toString() {
        return super.toString() + "[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    private native Rectangle getBounds(int var1);

    @Override
    public Rectangle getBounds() {
        return this.getBounds(this.screen.getScreen());
    }

    @Override
    public BufferCapabilities getBufferCapabilities() {
        if (bufferCaps == null) {
            bufferCaps = new BufferCapabilities(this.getImageCapabilities(), this.getImageCapabilities(), BufferCapabilities.FlipContents.PRIOR){

                @Override
                public boolean isMultiBufferAvailable() {
                    return true;
                }

                @Override
                public boolean isFullScreenRequired() {
                    return false;
                }

                @Override
                public boolean isPageFlipping() {
                    return true;
                }
            };
        }
        return bufferCaps;
    }

    @Override
    public ImageCapabilities getImageCapabilities() {
        if (imageCaps == null) {
            imageCaps = new ImageCapabilities(false);
        }
        return imageCaps;
    }

    @Override
    public synchronized void displayChanged() {
        this.solidloops = null;
        this.normalizingTransform = null;
    }

    @Override
    public void paletteChanged() {
    }

    public SurfaceData createSurfaceData(ComponentModel componentModel, int n) {
        return CPeerSurfaceData.createData(componentModel, n);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = null;
        colorModel = CGraphicsConfig.isQuartz() ? this.getColorModel(3) : this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new OffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    private boolean isFullScreenExclusive(Component component) {
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getDevice();
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return component == cGraphicsDevice.getFullScreenWindow();
    }

    public void assertOperationSupported(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (!this.isFullScreenExclusive(component)) {
            throw new AWTException("The operation requested is only supported on a full-screen exclusive window");
        }
    }

    public VolatileImage createBackBuffer(ComponentModel componentModel) {
        return new OSXBackBuffer((Component)componentModel.getTarget(), (OSXSurfaceData)componentModel.getSurfaceData());
    }

    public void flip(ComponentModel componentModel, Component component, VolatileImage volatileImage, BufferCapabilities.FlipContents flipContents) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            Graphics graphics = component.getGraphics();
            graphics.drawImage(volatileImage, 0, 0, n, n2, component);
            graphics.dispose();
        } else {
            Object object;
            CPeerSurfaceData cPeerSurfaceData = (CPeerSurfaceData)componentModel.getSurfaceData();
            try {
                object = ((OSXBackBuffer)volatileImage).getHWSurfaceData();
                cPeerSurfaceData.finishLazyDrawing();
                cPeerSurfaceData.flip((SurfaceData)object);
            }
            catch (InvalidPipeException invalidPipeException) {
                Graphics graphics = component.getGraphics();
                graphics.drawImage(volatileImage, 0, 0, n, n2, null);
                graphics.dispose();
            }
            if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
                object = volatileImage.getGraphics();
                ((Graphics)object).setColor(component.getBackground());
                ((Graphics)object).fillRect(0, 0, n, n2);
                ((Graphics)object).dispose();
            }
        }
    }

    protected native void flush(long var1);

    protected void flush(ComponentModel componentModel, long l) {
        this.flush(l);
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        sDefaultColorModelWithAlphaPre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        sDefaultColorModelWithAlpha = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        sDefaultColorModelNoAlpha = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    }
}

