/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Jpeg;
import com.lowagie.text.Jpeg2000;
import com.lowagie.text.Utilities;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageLoader {
    public static Image getPngImage(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                BufferedImage bufferedImage = ImageIO.read(is);
                return Image.getInstance(bufferedImage, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getGifImage(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                BufferedImage bufferedImage = ImageIO.read(is);
                return Image.getInstance(bufferedImage, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getTiffImage(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                BufferedImage bufferedImage = ImageIO.read(is);
                return Image.getInstance(bufferedImage, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getBmpImage(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                BufferedImage bufferedImage = ImageIO.read(is);
                return Image.getInstance(bufferedImage, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getJpegImage(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                byte[] imageBytes = Utilities.toByteArray(is);
                return new Jpeg(imageBytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getJpeg2000Image(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                byte[] imageBytes = Utilities.toByteArray(is);
                return new Jpeg2000(imageBytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getGifImage(byte[] imageData) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(imageData);){
                BufferedImage bufferedImage = ImageIO.read(is);
                return Image.getInstance(bufferedImage, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getPngImage(byte[] imageData) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(imageData);){
                BufferedImage bufferedImage = ImageIO.read(is);
                return Image.getInstance(bufferedImage, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getBmpImage(byte[] imageData) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(imageData);){
                BufferedImage bufferedImage = ImageIO.read(is);
                return Image.getInstance(bufferedImage, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getTiffImage(byte[] imageData) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(imageData);){
                BufferedImage bufferedImage = ImageIO.read(is);
                return Image.getInstance(bufferedImage, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getJpegImage(byte[] imageData) {
        try {
            return new Jpeg(imageData);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getJpeg2000Image(byte[] imageData) {
        try {
            return new Jpeg2000(imageData);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

