/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Collection;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

class OrFilter
extends Filter {
    private final Collection<? extends Filter> filters;

    OrFilter(Collection<? extends Filter> filters) {
        this.filters = Preconditions.notEmpty(filters, "filters must not be empty");
    }

    @Override
    public boolean shouldRun(Description description) {
        return this.filters.stream().anyMatch(filter -> filter.shouldRun(description));
    }

    @Override
    public String describe() {
        return this.filters.stream().map(Filter::describe).collect(Collectors.joining(" OR "));
    }
}

