/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.lang.reflect.Method;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorAwareFilter;
import org.junit.vintage.engine.discovery.TestClassCollector;

class MethodSelectorResolver
implements DiscoverySelectorResolver {
    MethodSelectorResolver() {
    }

    @Override
    public void resolve(EngineDiscoveryRequest request, ClassFilter classFilter, TestClassCollector collector) {
        request.getSelectorsByType(MethodSelector.class).forEach(selector -> this.resolve((MethodSelector)selector, classFilter, collector));
    }

    private void resolve(MethodSelector selector, ClassFilter classFilter, TestClassCollector collector) {
        Class<?> testClass = selector.getJavaClass();
        if (classFilter.test(testClass)) {
            Method testMethod = selector.getJavaMethod();
            Description methodDescription = Description.createTestDescription(testClass, testMethod.getName());
            collector.addFiltered(testClass, RunnerTestDescriptorAwareFilter.adapter(MethodSelectorResolver.matchMethodDescription(methodDescription)));
        }
    }

    private static Filter matchMethodDescription(final Description desiredDescription) {
        return new Filter(){

            @Override
            public boolean shouldRun(Description description) {
                if (description.isTest()) {
                    return desiredDescription.equals(description) || this.isParameterizedMethod(description);
                }
                for (Description each : description.getChildren()) {
                    if (!this.shouldRun(each)) continue;
                    return true;
                }
                return false;
            }

            private boolean isParameterizedMethod(Description description) {
                return description.getMethodName().startsWith(desiredDescription.getMethodName() + "[");
            }

            @Override
            public String describe() {
                return String.format("Method %s", desiredDescription.getDisplayName());
            }
        };
    }
}

