/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.util.Optional;
import java.util.concurrent.Callable;

class CustomContextClassLoaderExecutor {
    private final Optional<ClassLoader> customClassLoader;

    CustomContextClassLoaderExecutor(Optional<ClassLoader> customClassLoader) {
        this.customClassLoader = customClassLoader;
    }

    <T> T invoke(Callable<T> callable) throws Exception {
        if (this.customClassLoader.isPresent()) {
            return this.replaceThreadContextClassLoaderAndInvoke(this.customClassLoader.get(), callable);
        }
        return callable.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T replaceThreadContextClassLoaderAndInvoke(ClassLoader customClassLoader, Callable<T> callable) throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(customClassLoader);
            T t = callable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

