/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.JupiterConfiguration;

@API(status=API.Status.INTERNAL, since="5.4")
public class CachingJupiterConfiguration
implements JupiterConfiguration {
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();
    private final JupiterConfiguration delegate;

    public CachingJupiterConfiguration(JupiterConfiguration delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<String> getRawConfigurationParameter(String key) {
        return this.delegate.getRawConfigurationParameter(key);
    }

    @Override
    public boolean isParallelExecutionEnabled() {
        return (Boolean)this.cache.computeIfAbsent("junit.jupiter.execution.parallel.enabled", key -> this.delegate.isParallelExecutionEnabled());
    }

    @Override
    public boolean isExtensionAutoDetectionEnabled() {
        return (Boolean)this.cache.computeIfAbsent("junit.jupiter.extensions.autodetection.enabled", key -> this.delegate.isExtensionAutoDetectionEnabled());
    }

    @Override
    public ExecutionMode getDefaultExecutionMode() {
        return (ExecutionMode)((Object)this.cache.computeIfAbsent("junit.jupiter.execution.parallel.mode.default", key -> this.delegate.getDefaultExecutionMode()));
    }

    @Override
    public TestInstance.Lifecycle getDefaultTestInstanceLifecycle() {
        return (TestInstance.Lifecycle)((Object)this.cache.computeIfAbsent("junit.jupiter.testinstance.lifecycle.default", key -> this.delegate.getDefaultTestInstanceLifecycle()));
    }

    @Override
    public Predicate<ExecutionCondition> getExecutionConditionFilter() {
        return (Predicate)this.cache.computeIfAbsent("junit.jupiter.conditions.deactivate", key -> this.delegate.getExecutionConditionFilter());
    }
}

