/*
 * Decompiled with CFR 0.152.
 */
package tests.junittests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

class TestResourceHandler
extends CefResourceHandlerAdapter {
    private int offset_ = 0;
    private final String content_;
    private final String mimeType_;
    private final HashMap<String, String> headerMap_;

    TestResourceHandler(String content, String mimeType, HashMap<String, String> headerMap) {
        this.content_ = content;
        this.mimeType_ = mimeType;
        this.headerMap_ = headerMap;
    }

    public boolean processRequest(CefRequest request, CefCallback callback) {
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(CefResponse response, IntRef response_length, StringRef redirectUrl) {
        response_length.set(this.content_.length());
        response.setMimeType(this.mimeType_);
        response.setStatus(200);
        if (this.headerMap_ != null) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            response.getHeaderMap(headerMap);
            headerMap.putAll(this.headerMap_);
            response.setHeaderMap(headerMap);
        }
    }

    public boolean readResponse(byte[] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
        int length = this.content_.length();
        if (this.offset_ >= length) {
            return false;
        }
        int endPos = this.offset_ + bytes_to_read;
        String dataToSend = endPos > length ? this.content_.substring(this.offset_) : this.content_.substring(this.offset_, endPos);
        ByteBuffer result = ByteBuffer.wrap(data_out);
        result.put(dataToSend.getBytes());
        bytes_read.set(dataToSend.length());
        this.offset_ = endPos;
        return true;
    }
}

