/*
 * Decompiled with CFR 0.152.
 */
package tests.junittests;

import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import tests.junittests.TestFrame;
import tests.junittests.TestSetupExtension;

@ExtendWith(value={TestSetupExtension.class})
class DisplayHandlerTest {
    private final String testUrl_ = "http://test.com/test.html";
    private final String testContent_ = "<html><head><title>Test Title</title></head><body>Test!</body></html>";
    private boolean gotCallback_ = false;

    DisplayHandlerTest() {
    }

    @Test
    void onTitleChange() {
        TestFrame frame = new TestFrame(){

            @Override
            protected void setupTest() {
                this.client_.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

                    public void onTitleChange(CefBrowser browser, String title) {
                        Assertions.assertFalse((boolean)DisplayHandlerTest.this.gotCallback_);
                        DisplayHandlerTest.this.gotCallback_ = true;
                        Assertions.assertEquals((Object)"Test Title", (Object)title);
                        this.terminateTest();
                    }
                });
                this.addResource("http://test.com/test.html", "<html><head><title>Test Title</title></head><body>Test!</body></html>", "text/html");
                this.createBrowser("http://test.com/test.html");
                super.setupTest();
            }
        };
        frame.awaitCompletion();
        Assertions.assertTrue((boolean)this.gotCallback_);
    }

    @Test
    void onAddressChange() {
        TestFrame frame = new TestFrame(){

            @Override
            protected void setupTest() {
                this.client_.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

                    public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                        Assertions.assertFalse((boolean)DisplayHandlerTest.this.gotCallback_);
                        DisplayHandlerTest.this.gotCallback_ = true;
                        Assertions.assertEquals((Object)url, (Object)"http://test.com/test.html");
                        this.terminateTest();
                    }
                });
                this.addResource("http://test.com/test.html", "<html><head><title>Test Title</title></head><body>Test!</body></html>", "text/html");
                this.createBrowser("http://test.com/test.html");
                super.setupTest();
            }
        };
        frame.awaitCompletion();
        Assertions.assertTrue((boolean)this.gotCallback_);
    }
}

