/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class AquaMnemonicHandler {
    static AltProcessor altProcessor = new AltProcessor();
    static boolean isMnemonicHidden = true;

    public static KeyEventPostProcessor getInstance() {
        return altProcessor;
    }

    public static void setMnemonicHidden(boolean bl) {
        isMnemonicHidden = UIManager.getBoolean("Button.showMnemonics") ? false : bl;
    }

    public static boolean isMnemonicHidden() {
        if (UIManager.getBoolean("Button.showMnemonics")) {
            isMnemonicHidden = false;
        }
        return isMnemonicHidden;
    }

    static void repaintMnemonicsInWindow(Window window) {
        Window[] windowArray;
        if (window == null || !window.isShowing()) {
            return;
        }
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            AquaMnemonicHandler.repaintMnemonicsInWindow(window2);
        }
        AquaMnemonicHandler.repaintMnemonicsInContainer(window);
    }

    static void repaintMnemonicsInContainer(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component == null || !component.isVisible()) continue;
            if (component instanceof AbstractButton && ((AbstractButton)component).getMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (component instanceof JLabel && ((JLabel)component).getDisplayedMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (!(component instanceof Container)) continue;
            AquaMnemonicHandler.repaintMnemonicsInContainer((Container)component);
        }
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        AltProcessor() {
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != 18) {
                return false;
            }
            JRootPane jRootPane = SwingUtilities.getRootPane(keyEvent.getComponent());
            Window window = jRootPane == null ? null : SwingUtilities.getWindowAncestor(jRootPane);
            switch (keyEvent.getID()) {
                case 401: {
                    AquaMnemonicHandler.setMnemonicHidden(false);
                    break;
                }
                case 402: {
                    AquaMnemonicHandler.setMnemonicHidden(true);
                }
            }
            AquaMnemonicHandler.repaintMnemonicsInWindow(window);
            return false;
        }
    }
}

