/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuPainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

class AquaComboBoxRendererInternal
extends JLabel
implements ListCellRenderer {
    final JComboBox fComboBox;
    boolean fSelected;
    boolean fChecked;
    boolean fInList;
    boolean fEditable;
    boolean fDrawCheckedItem = true;

    public AquaComboBoxRendererInternal(JComboBox jComboBox) {
        this.fComboBox = jComboBox;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        String string = this.getText();
        if (string == null || "".equals(string)) {
            this.setText(" ");
            dimension = super.getPreferredSize();
            this.setText("");
        } else {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    @Override
    protected void paintBorder(Graphics graphics) {
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.fInList = n >= 0;
        this.fSelected = bl;
        if (n < 0) {
            n = this.fComboBox.getSelectedIndex();
        }
        if (n >= 0) {
            Object e = this.fComboBox.getItemAt(n);
            this.fChecked = this.fInList && e != null && e.equals(this.fComboBox.getSelectedItem());
        } else {
            this.fChecked = false;
        }
        this.fEditable = this.fComboBox.isEditable();
        if (bl) {
            if (this.fEditable) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            }
        } else if (this.fEditable) {
            this.setBackground(UIManager.getColor("List.background"));
            this.setForeground(UIManager.getColor("List.foreground"));
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setFont(jList.getFont());
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
        } else {
            this.setText(object == null ? " " : object.toString());
        }
        return this;
    }

    @Override
    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = 1;
        insets.bottom = 1;
        insets.right = 5;
        insets.left = this.fInList && !this.fEditable ? 23 : 5;
        return insets;
    }

    protected void setDrawCheckedItem(boolean bl) {
        this.fDrawCheckedItem = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.fInList) {
            if (this.fSelected && !this.fEditable) {
                AquaMenuPainter.sPainter.paintSelectedMenuItemBackground(graphics, this.getWidth(), this.getHeight());
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.fChecked && !this.fEditable && this.fDrawCheckedItem) {
                int n = this.getHeight() - 4;
                graphics.setColor(this.getForeground());
                graphics.drawString("\u2713", 6, n);
            }
        }
        super.paintComponent(graphics);
    }
}

