/*
 * Decompiled with CFR 0.152.
 */
package apple.laf;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public final class JRSUIConstants {
    private static native long getPtrForConstant(int var0);

    static Hit getHit(int n) {
        switch (n) {
            case 0: {
                return Hit.NONE;
            }
            case 1: {
                return Hit.HIT;
            }
            case 2: {
                return ScrollBarHit.THUMB;
            }
            case 3: {
                return ScrollBarHit.TRACK_MIN;
            }
            case 4: {
                return ScrollBarHit.TRACK_MAX;
            }
            case 5: {
                return ScrollBarHit.ARROW_MIN;
            }
            case 6: {
                return ScrollBarHit.ARROW_MAX;
            }
            case 7: {
                return ScrollBarHit.ARROW_MAX_INSIDE;
            }
            case 8: {
                return ScrollBarHit.ARROW_MIN_INSIDE;
            }
        }
        return Hit.UNKNOWN;
    }

    static String getConstantName(Object object) {
        Class<?> clazz = object.getClass();
        try {
            for (Field field : clazz.getFields()) {
                if (field.get(null) != object) continue;
                return field.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz.getSimpleName();
    }

    public static class ScrollBarHit
    extends Hit {
        private static final int _thumb = 2;
        public static final ScrollBarHit THUMB = new ScrollBarHit(2);
        private static final int _trackMin = 3;
        public static final ScrollBarHit TRACK_MIN = new ScrollBarHit(3);
        private static final int _trackMax = 4;
        public static final ScrollBarHit TRACK_MAX = new ScrollBarHit(4);
        private static final int _arrowMin = 5;
        public static final ScrollBarHit ARROW_MIN = new ScrollBarHit(5);
        private static final int _arrowMax = 6;
        public static final ScrollBarHit ARROW_MAX = new ScrollBarHit(6);
        private static final int _arrowMaxInside = 7;
        public static final ScrollBarHit ARROW_MAX_INSIDE = new ScrollBarHit(7);
        private static final int _arrowMinInside = 8;
        public static final ScrollBarHit ARROW_MIN_INSIDE = new ScrollBarHit(8);

        ScrollBarHit(int n) {
            super(n);
        }
    }

    public static class Hit {
        private static final int _unknown = -1;
        public static final Hit UNKNOWN = new Hit(-1);
        private static final int _none = 0;
        public static final Hit NONE = new Hit(0);
        private static final int _hit = 1;
        public static final Hit HIT = new Hit(1);
        final int hit;

        Hit(int n) {
            this.hit = n;
        }

        public boolean isHit() {
            return this.hit > 0;
        }

        public String toString() {
            return JRSUIConstants.getConstantName(this);
        }
    }

    public static class Widget
    extends Property {
        private static final byte SHIFT = 42;
        private static final byte SIZE = 7;
        private static final long MASK = 558551906910208L;
        private static final PropertyEncoding widget = new PropertyEncoding(558551906910208L, 42);
        private static final byte _background = 1;
        public static final Widget BACKGROUND = new Widget(1);
        private static final byte _buttonBevel = 2;
        public static final Widget BUTTON_BEVEL = new Widget(2);
        private static final byte _buttonBevelInset = 3;
        public static final Widget BUTTON_BEVEL_INSET = new Widget(3);
        private static final byte _buttonBevelRound = 4;
        public static final Widget BUTTON_BEVEL_ROUND = new Widget(4);
        private static final byte _buttonCheckBox = 5;
        public static final Widget BUTTON_CHECK_BOX = new Widget(5);
        private static final byte _buttonComboBox = 6;
        public static final Widget BUTTON_COMBO_BOX = new Widget(6);
        private static final byte _buttonComboBoxInset = 7;
        public static final Widget BUTTON_COMBO_BOX_INSET = new Widget(7);
        private static final byte _buttonDisclosure = 8;
        public static final Widget BUTTON_DISCLOSURE = new Widget(8);
        private static final byte _buttonListHeader = 9;
        public static final Widget BUTTON_LIST_HEADER = new Widget(9);
        private static final byte _buttonLittleArrows = 10;
        public static final Widget BUTTON_LITTLE_ARROWS = new Widget(10);
        private static final byte _buttonPopDown = 11;
        public static final Widget BUTTON_POP_DOWN = new Widget(11);
        private static final byte _buttonPopDownInset = 12;
        public static final Widget BUTTON_POP_DOWN_INSET = new Widget(12);
        private static final byte _buttonPopDownSquare = 13;
        public static final Widget BUTTON_POP_DOWN_SQUARE = new Widget(13);
        private static final byte _buttonPopUp = 14;
        public static final Widget BUTTON_POP_UP = new Widget(14);
        private static final byte _buttonPopUpInset = 15;
        public static final Widget BUTTON_POP_UP_INSET = new Widget(15);
        private static final byte _buttonPopUpSquare = 16;
        public static final Widget BUTTON_POP_UP_SQUARE = new Widget(16);
        private static final byte _buttonPush = 17;
        public static final Widget BUTTON_PUSH = new Widget(17);
        private static final byte _buttonPushScope = 18;
        public static final Widget BUTTON_PUSH_SCOPE = new Widget(18);
        private static final byte _buttonPushScope2 = 19;
        public static final Widget BUTTON_PUSH_SCOPE2 = new Widget(19);
        private static final byte _buttonPushTextured = 20;
        public static final Widget BUTTON_PUSH_TEXTURED = new Widget(20);
        private static final byte _buttonPushInset = 21;
        public static final Widget BUTTON_PUSH_INSET = new Widget(21);
        private static final byte _buttonPushInset2 = 22;
        public static final Widget BUTTON_PUSH_INSET2 = new Widget(22);
        private static final byte _buttonRadio = 23;
        public static final Widget BUTTON_RADIO = new Widget(23);
        private static final byte _buttonRound = 24;
        public static final Widget BUTTON_ROUND = new Widget(24);
        private static final byte _buttonRoundHelp = 25;
        public static final Widget BUTTON_ROUND_HELP = new Widget(25);
        private static final byte _buttonRoundInset = 26;
        public static final Widget BUTTON_ROUND_INSET = new Widget(26);
        private static final byte _buttonRoundInset2 = 27;
        public static final Widget BUTTON_ROUND_INSET2 = new Widget(27);
        private static final byte _buttonSearchFieldCancel = 28;
        public static final Widget BUTTON_SEARCH_FIELD_CANCEL = new Widget(28);
        private static final byte _buttonSearchFieldFind = 29;
        public static final Widget BUTTON_SEARCH_FIELD_FIND = new Widget(29);
        private static final byte _buttonSegmented = 30;
        public static final Widget BUTTON_SEGMENTED = new Widget(30);
        private static final byte _buttonSegmentedInset = 31;
        public static final Widget BUTTON_SEGMENTED_INSET = new Widget(31);
        private static final byte _buttonSegmentedInset2 = 32;
        public static final Widget BUTTON_SEGMENTED_INSET2 = new Widget(32);
        private static final byte _buttonSegmentedSCurve = 33;
        public static final Widget BUTTON_SEGMENTED_SCURVE = new Widget(33);
        private static final byte _buttonSegmentedTextured = 34;
        public static final Widget BUTTON_SEGMENTED_TEXTURED = new Widget(34);
        private static final byte _buttonSegmentedToolbar = 35;
        public static final Widget BUTTON_SEGMENTED_TOOLBAR = new Widget(35);
        private static final byte _dial = 36;
        public static final Widget DIAL = new Widget(36);
        private static final byte _disclosureTriangle = 37;
        public static final Widget DISCLOSURE_TRIANGLE = new Widget(37);
        private static final byte _dividerGrabber = 38;
        public static final Widget DIVIDER_GRABBER = new Widget(38);
        private static final byte _dividerSeparatorBar = 39;
        public static final Widget DIVIDER_SEPARATOR_BAR = new Widget(39);
        private static final byte _dividerSplitter = 40;
        public static final Widget DIVIDER_SPLITTER = new Widget(40);
        private static final byte _focus = 41;
        public static final Widget FOCUS = new Widget(41);
        private static final byte _frameGroupBox = 42;
        public static final Widget FRAME_GROUP_BOX = new Widget(42);
        private static final byte _frameGroupBoxSecondary = 43;
        public static final Widget FRAME_GROUP_BOX_SECONDARY = new Widget(43);
        private static final byte _frameListBox = 44;
        public static final Widget FRAME_LIST_BOX = new Widget(44);
        private static final byte _framePlacard = 45;
        public static final Widget FRAME_PLACARD = new Widget(45);
        private static final byte _frameTextField = 46;
        public static final Widget FRAME_TEXT_FIELD = new Widget(46);
        private static final byte _frameTextFieldRound = 47;
        public static final Widget FRAME_TEXT_FIELD_ROUND = new Widget(47);
        private static final byte _frameWell = 48;
        public static final Widget FRAME_WELL = new Widget(48);
        private static final byte _growBox = 49;
        public static final Widget GROW_BOX = new Widget(49);
        private static final byte _growBoxTextured = 50;
        public static final Widget GROW_BOX_TEXTURED = new Widget(50);
        private static final byte _gradient = 51;
        public static final Widget GRADIENT = new Widget(51);
        private static final byte _menu = 52;
        public static final Widget MENU = new Widget(52);
        private static final byte _menuItem = 53;
        public static final Widget MENU_ITEM = new Widget(53);
        private static final byte _menuBar = 54;
        public static final Widget MENU_BAR = new Widget(54);
        private static final byte _menuTitle = 55;
        public static final Widget MENU_TITLE = new Widget(55);
        private static final byte _progressBar = 56;
        public static final Widget PROGRESS_BAR = new Widget(56);
        private static final byte _progressIndeterminateBar = 57;
        public static final Widget PROGRESS_INDETERMINATE_BAR = new Widget(57);
        private static final byte _progressRelevance = 58;
        public static final Widget PROGRESS_RELEVANCE = new Widget(58);
        private static final byte _progressSpinner = 59;
        public static final Widget PROGRESS_SPINNER = new Widget(59);
        private static final byte _scrollBar = 60;
        public static final Widget SCROLL_BAR = new Widget(60);
        private static final byte _scrollColumnSizer = 61;
        public static final Widget SCROLL_COLUMN_SIZER = new Widget(61);
        private static final byte _slider = 62;
        public static final Widget SLIDER = new Widget(62);
        private static final byte _sliderThumb = 63;
        public static final Widget SLIDER_THUMB = new Widget(63);
        private static final byte _synchronization = 64;
        public static final Widget SYNCHRONIZATION = new Widget(64);
        private static final byte _tab = 65;
        public static final Widget TAB = new Widget(65);
        private static final byte _titleBarCloseBox = 66;
        public static final Widget TITLE_BAR_CLOSE_BOX = new Widget(66);
        private static final byte _titleBarCollapseBox = 67;
        public static final Widget TITLE_BAR_COLLAPSE_BOX = new Widget(67);
        private static final byte _titleBarZoomBox = 68;
        public static final Widget TITLE_BAR_ZOOM_BOX = new Widget(68);
        private static final byte _titleBarToolbarButton = 69;
        public static final Widget TITLE_BAR_TOOLBAR_BUTTON = new Widget(69);
        private static final byte _toolbarItemWell = 70;
        public static final Widget TOOLBAR_ITEM_WELL = new Widget(70);
        private static final byte _windowFrame = 71;
        public static final Widget WINDOW_FRAME = new Widget(71);

        Widget(byte by) {
            super(widget, by);
        }
    }

    public static class Animating
    extends Property {
        private static final byte SHIFT = 41;
        private static final byte SIZE = 1;
        private static final long MASK = 0x20000000000L;
        private static final PropertyEncoding animating = new PropertyEncoding(0x20000000000L, 41);
        private static final byte _no = 0;
        public static final Animating NO = new Animating(0);
        private static final byte _yes = 1;
        public static final Animating YES = new Animating(1);

        Animating(byte by) {
            super(animating, by);
        }
    }

    public static class BooleanValue
    extends Property {
        private static final byte SHIFT = 40;
        private static final byte SIZE = 1;
        private static final long MASK = 0x10000000000L;
        private static final PropertyEncoding booleanValue = new PropertyEncoding(0x10000000000L, 40);
        private static final byte _no = 0;
        public static final BooleanValue NO = new BooleanValue(0);
        private static final byte _yes = 1;
        public static final BooleanValue YES = new BooleanValue(1);

        BooleanValue(byte by) {
            super(booleanValue, by);
        }
    }

    public static class ShowArrows
    extends Property {
        private static final byte SHIFT = 39;
        private static final byte SIZE = 1;
        private static final long MASK = 0x8000000000L;
        private static final PropertyEncoding showArrows = new PropertyEncoding(0x8000000000L, 39);
        private static final byte _no = 0;
        public static final ShowArrows NO = new ShowArrows(0);
        private static final byte _yes = 1;
        public static final ShowArrows YES = new ShowArrows(1);

        ShowArrows(byte by) {
            super(showArrows, by);
        }
    }

    public static class WindowClipCorners
    extends Property {
        private static final byte SHIFT = 38;
        private static final byte SIZE = 1;
        private static final long MASK = 0x4000000000L;
        private static final PropertyEncoding focused = new PropertyEncoding(0x4000000000L, 38);
        private static final byte _no = 0;
        public static final WindowClipCorners NO = new WindowClipCorners(0);
        private static final byte _yes = 1;
        public static final WindowClipCorners YES = new WindowClipCorners(1);

        WindowClipCorners(byte by) {
            super(focused, by);
        }
    }

    public static class WindowTitleBarSeparator
    extends Property {
        private static final byte SHIFT = 37;
        private static final byte SIZE = 1;
        private static final long MASK = 0x2000000000L;
        private static final PropertyEncoding focused = new PropertyEncoding(0x2000000000L, 37);
        private static final byte _no = 0;
        public static final WindowTitleBarSeparator NO = new WindowTitleBarSeparator(0);
        private static final byte _yes = 1;
        public static final WindowTitleBarSeparator YES = new WindowTitleBarSeparator(1);

        WindowTitleBarSeparator(byte by) {
            super(focused, by);
        }
    }

    public static class NothingToScroll
    extends Property {
        private static final byte SHIFT = 36;
        private static final byte SIZE = 1;
        private static final long MASK = 0x1000000000L;
        private static final PropertyEncoding focused = new PropertyEncoding(0x1000000000L, 36);
        private static final byte _no = 0;
        public static final NothingToScroll NO = new NothingToScroll(0);
        private static final byte _yes = 1;
        public static final NothingToScroll YES = new NothingToScroll(1);

        NothingToScroll(byte by) {
            super(focused, by);
        }
    }

    public static class SegmentTrailingSeparator
    extends Property {
        private static final byte SHIFT = 35;
        private static final byte SIZE = 1;
        private static final long MASK = 0x800000000L;
        private static final PropertyEncoding focused = new PropertyEncoding(0x800000000L, 35);
        private static final byte _no = 0;
        public static final SegmentTrailingSeparator NO = new SegmentTrailingSeparator(0);
        private static final byte _yes = 1;
        public static final SegmentTrailingSeparator YES = new SegmentTrailingSeparator(1);

        SegmentTrailingSeparator(byte by) {
            super(focused, by);
        }
    }

    public static class FrameOnly
    extends Property {
        private static final byte SHIFT = 34;
        private static final byte SIZE = 1;
        private static final long MASK = 0x400000000L;
        private static final PropertyEncoding focused = new PropertyEncoding(0x400000000L, 34);
        private static final byte _no = 0;
        public static final FrameOnly NO = new FrameOnly(0);
        private static final byte _yes = 1;
        public static final FrameOnly YES = new FrameOnly(1);

        FrameOnly(byte by) {
            super(focused, by);
        }
    }

    public static class ArrowsOnly
    extends Property {
        private static final byte SHIFT = 33;
        private static final byte SIZE = 1;
        private static final long MASK = 0x200000000L;
        private static final PropertyEncoding focused = new PropertyEncoding(0x200000000L, 33);
        private static final byte _no = 0;
        public static final ArrowsOnly NO = new ArrowsOnly(0);
        private static final byte _yes = 1;
        public static final ArrowsOnly YES = new ArrowsOnly(1);

        ArrowsOnly(byte by) {
            super(focused, by);
        }
    }

    public static class NoIndicator
    extends Property {
        private static final byte SHIFT = 32;
        private static final byte SIZE = 1;
        private static final long MASK = 0x100000000L;
        private static final PropertyEncoding noIndicator = new PropertyEncoding(0x100000000L, 32);
        private static final byte _no = 0;
        public static final NoIndicator NO = new NoIndicator(0);
        private static final byte _yes = 1;
        public static final NoIndicator YES = new NoIndicator(1);

        NoIndicator(byte by) {
            super(noIndicator, by);
        }
    }

    public static class IndicatorOnly
    extends Property {
        private static final byte SHIFT = 31;
        private static final byte SIZE = 1;
        private static final long MASK = 0x80000000L;
        private static final PropertyEncoding indicatorOnly = new PropertyEncoding(0x80000000L, 31);
        private static final byte _no = 0;
        public static final IndicatorOnly NO = new IndicatorOnly(0);
        private static final byte _yes = 1;
        public static final IndicatorOnly YES = new IndicatorOnly(1);

        IndicatorOnly(byte by) {
            super(indicatorOnly, by);
        }
    }

    public static class Focused
    extends Property {
        private static final byte SHIFT = 30;
        private static final byte SIZE = 1;
        private static final long MASK = 0x40000000L;
        private static final PropertyEncoding focused = new PropertyEncoding(0x40000000L, 30);
        private static final byte _no = 0;
        public static final Focused NO = new Focused(0);
        private static final byte _yes = 1;
        public static final Focused YES = new Focused(1);

        Focused(byte by) {
            super(focused, by);
        }
    }

    public static class WindowType
    extends Property {
        private static final byte SHIFT = 28;
        private static final byte SIZE = 2;
        private static final long MASK = 0x30000000L;
        private static final PropertyEncoding windowType = new PropertyEncoding(0x30000000L, 28);
        private static final byte _document = 1;
        public static final WindowType DOCUMENT = new WindowType(1);
        private static final byte _utility = 2;
        public static final WindowType UTILITY = new WindowType(2);
        private static final byte _titlelessUtility = 3;
        public static final WindowType TITLELESS_UTILITY = new WindowType(3);

        WindowType(byte by) {
            super(windowType, by);
        }
    }

    public static class Variant
    extends Property {
        private static final byte SHIFT = 24;
        private static final byte SIZE = 4;
        private static final long MASK = 0xF000000L;
        private static final PropertyEncoding variant = new PropertyEncoding(0xF000000L, 24);
        private static final byte _menuGlyph = 1;
        public static final Variant MENU_GLYPH = new Variant(1);
        private static final byte _menuPopup = 2;
        public static final Variant MENU_POPUP = new Variant(2);
        private static final byte _menuPulldown = 3;
        public static final Variant MENU_PULLDOWN = new Variant(3);
        private static final byte _menuHierarchical = 4;
        public static final Variant MENU_HIERARCHICAL = new Variant(4);
        private static final byte _gradientListBackgroundEven = 5;
        public static final Variant GRADIENT_LIST_BACKGROUND_EVEN = new Variant(5);
        private static final byte _gradientListBackgroundOdd = 6;
        public static final Variant GRADIENT_LIST_BACKGROUND_ODD = new Variant(6);
        private static final byte _gradientSideBar = 7;
        public static final Variant GRADIENT_SIDE_BAR = new Variant(7);
        private static final byte _gradientSideBarSelection = 8;
        public static final Variant GRADIENT_SIDE_BAR_SELECTION = new Variant(8);
        private static final byte _gradientSideBarFocusedSelection = 9;
        public static final Variant GRADIENT_SIDE_BAR_FOCUSED_SELECTION = new Variant(9);

        Variant(byte by) {
            super(variant, by);
        }
    }

    public static class ScrollBarPart
    extends Property {
        private static final byte SHIFT = 20;
        private static final byte SIZE = 4;
        private static final long MASK = 0xF00000L;
        private static final PropertyEncoding scrollBarPart = new PropertyEncoding(0xF00000L, 20);
        private static final byte _none = 1;
        public static final ScrollBarPart NONE = new ScrollBarPart(1);
        private static final byte _thumb = 2;
        public static final ScrollBarPart THUMB = new ScrollBarPart(2);
        private static final byte _arrowMin = 3;
        public static final ScrollBarPart ARROW_MIN = new ScrollBarPart(3);
        private static final byte _arrowMax = 4;
        public static final ScrollBarPart ARROW_MAX = new ScrollBarPart(4);
        private static final byte _arrowMaxInside = 5;
        public static final ScrollBarPart ARROW_MAX_INSIDE = new ScrollBarPart(5);
        private static final byte _arrowMinInside = 6;
        public static final ScrollBarPart ARROW_MIN_INSIDE = new ScrollBarPart(6);
        private static final byte _trackMin = 7;
        public static final ScrollBarPart TRACK_MIN = new ScrollBarPart(7);
        private static final byte _trackMax = 8;
        public static final ScrollBarPart TRACK_MAX = new ScrollBarPart(8);

        ScrollBarPart(byte by) {
            super(scrollBarPart, by);
        }
    }

    public static class SegmentPosition
    extends Property {
        private static final byte SHIFT = 17;
        private static final byte SIZE = 3;
        private static final long MASK = 917504L;
        private static final PropertyEncoding segmentPosition = new PropertyEncoding(917504L, 17);
        private static final byte _first = 1;
        public static final SegmentPosition FIRST = new SegmentPosition(1);
        private static final byte _middle = 2;
        public static final SegmentPosition MIDDLE = new SegmentPosition(2);
        private static final byte _last = 3;
        public static final SegmentPosition LAST = new SegmentPosition(3);
        private static final byte _only = 4;
        public static final SegmentPosition ONLY = new SegmentPosition(4);

        SegmentPosition(byte by) {
            super(segmentPosition, by);
        }
    }

    public static class AlignmentHorizontal
    extends Property {
        private static final byte SHIFT = 15;
        private static final byte SIZE = 2;
        private static final long MASK = 98304L;
        private static final PropertyEncoding alignmentHorizontal = new PropertyEncoding(98304L, 15);
        private static final byte _left = 1;
        public static final AlignmentHorizontal LEFT = new AlignmentHorizontal(1);
        private static final byte _center = 2;
        public static final AlignmentHorizontal CENTER = new AlignmentHorizontal(2);
        private static final byte _right = 3;
        public static final AlignmentHorizontal RIGHT = new AlignmentHorizontal(3);

        AlignmentHorizontal(byte by) {
            super(alignmentHorizontal, by);
        }
    }

    public static class AlignmentVertical
    extends Property {
        private static final byte SHIFT = 13;
        private static final byte SIZE = 2;
        private static final long MASK = 24576L;
        private static final PropertyEncoding alignmentVertical = new PropertyEncoding(24576L, 13);
        private static final byte _top = 1;
        public static final AlignmentVertical TOP = new AlignmentVertical(1);
        private static final byte _center = 2;
        public static final AlignmentVertical CENTER = new AlignmentVertical(2);
        private static final byte _bottom = 3;
        public static final AlignmentVertical BOTTOM = new AlignmentVertical(3);

        AlignmentVertical(byte by) {
            super(alignmentVertical, by);
        }
    }

    public static class Orientation
    extends Property {
        private static final byte SHIFT = 11;
        private static final byte SIZE = 2;
        private static final long MASK = 6144L;
        private static final PropertyEncoding orientation = new PropertyEncoding(6144L, 11);
        private static final byte _horizontal = 1;
        public static final Orientation HORIZONTAL = new Orientation(1);
        private static final byte _vertical = 2;
        public static final Orientation VERTICAL = new Orientation(2);

        Orientation(byte by) {
            super(orientation, by);
        }
    }

    public static class Direction
    extends Property {
        private static final byte SHIFT = 7;
        private static final byte SIZE = 4;
        private static final long MASK = 1920L;
        private static final PropertyEncoding direction = new PropertyEncoding(1920L, 7);
        private static final byte _none = 1;
        public static final Direction NONE = new Direction(1);
        private static final byte _up = 2;
        public static final Direction UP = new Direction(2);
        private static final byte _down = 3;
        public static final Direction DOWN = new Direction(3);
        private static final byte _left = 4;
        public static final Direction LEFT = new Direction(4);
        private static final byte _right = 5;
        public static final Direction RIGHT = new Direction(5);
        private static final byte _north = 6;
        public static final Direction NORTH = new Direction(6);
        private static final byte _south = 7;
        public static final Direction SOUTH = new Direction(7);
        private static final byte _east = 8;
        public static final Direction EAST = new Direction(8);
        private static final byte _west = 9;
        public static final Direction WEST = new Direction(9);

        Direction(byte by) {
            super(direction, by);
        }
    }

    public static class State
    extends Property {
        private static final byte SHIFT = 3;
        private static final byte SIZE = 4;
        private static final long MASK = 120L;
        private static final PropertyEncoding state = new PropertyEncoding(120L, 3);
        private static final byte _active = 1;
        public static final State ACTIVE = new State(1);
        private static final byte _inactive = 2;
        public static final State INACTIVE = new State(2);
        private static final byte _disabled = 3;
        public static final State DISABLED = new State(3);
        private static final byte _pressed = 4;
        public static final State PRESSED = new State(4);
        private static final byte _pulsed = 5;
        public static final State PULSED = new State(5);
        private static final byte _rollover = 6;
        public static final State ROLLOVER = new State(6);
        private static final byte _drag = 7;
        public static final State DRAG = new State(7);

        State(byte by) {
            super(state, by);
        }
    }

    public static class Size
    extends Property {
        private static final byte SHIFT = 0;
        private static final byte SIZE = 3;
        private static final long MASK = 7L;
        private static final PropertyEncoding size = new PropertyEncoding(7L, 0);
        private static final byte _mini = 1;
        public static final Size MINI = new Size(1);
        private static final byte _small = 2;
        public static final Size SMALL = new Size(2);
        private static final byte _regular = 3;
        public static final Size REGULAR = new Size(3);
        private static final byte _large = 4;
        public static final Size LARGE = new Size(4);

        Size(byte by) {
            super(size, by);
        }
    }

    static class Property {
        final PropertyEncoding encoding;
        final long value;
        final byte ordinal;

        Property(PropertyEncoding propertyEncoding, byte by) {
            this.encoding = propertyEncoding;
            this.value = (long)by << propertyEncoding.shift;
            this.ordinal = by;
        }

        public long apply(long l) {
            return l & (this.encoding.mask ^ 0xFFFFFFFFFFFFFFFFL) | this.value;
        }

        public String toString() {
            return JRSUIConstants.getConstantName(this);
        }
    }

    static class PropertyEncoding {
        final long mask;
        final byte shift;

        PropertyEncoding(long l, byte by) {
            this.mask = l;
            this.shift = by;
        }
    }

    static class DoubleValue {
        protected static final byte TYPE_CODE = 1;
        final double doubleValue;

        DoubleValue(double d) {
            this.doubleValue = d;
        }

        public byte getTypeCode() {
            return 1;
        }

        public void putValueInBuffer(ByteBuffer byteBuffer) {
            byteBuffer.putDouble(this.doubleValue);
        }

        public boolean equals(Object object) {
            return object instanceof DoubleValue && ((DoubleValue)object).doubleValue == this.doubleValue;
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.doubleValue);
            return (int)(l ^ l >>> 32);
        }

        public String toString() {
            return Double.toString(this.doubleValue);
        }
    }

    static class Key {
        protected static final int _value = 20;
        public static final Key VALUE = new Key(20);
        protected static final int _thumbProportion = 24;
        public static final Key THUMB_PROPORTION = new Key(24);
        protected static final int _thumbStart = 25;
        public static final Key THUMB_START = new Key(25);
        protected static final int _windowTitleBarHeight = 28;
        public static final Key WINDOW_TITLE_BAR_HEIGHT = new Key(28);
        protected static final int _animationFrame = 23;
        public static final Key ANIMATION_FRAME = new Key(23);
        final int constant;
        private long ptr;

        private Key(int n) {
            this.constant = n;
        }

        long getConstantPtr() {
            if (this.ptr != 0L) {
                return this.ptr;
            }
            this.ptr = JRSUIConstants.getPtrForConstant(this.constant);
            if (this.ptr != 0L) {
                return this.ptr;
            }
            throw new RuntimeException("Constant not implemented in native: " + this);
        }

        public String toString() {
            return JRSUIConstants.getConstantName(this) + (this.ptr == 0L ? "(unlinked)" : "");
        }
    }
}

