/*
 * Decompiled with CFR 0.152.
 */
package tests.junittests;

import org.cef.browser.CefBrowser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import tests.junittests.TestFrame;
import tests.junittests.TestSetupExtension;

@ExtendWith(value={TestSetupExtension.class})
class TestFrameTest {
    private boolean gotSetupTest_ = false;
    private boolean gotCleanupTest_ = false;
    private boolean gotLoadingStateChange_ = false;

    TestFrameTest() {
    }

    @Test
    void minimal() {
        String testUrl = "http://test.com/test.html";
        TestFrame frame = new TestFrame(){

            @Override
            protected void setupTest() {
                Assertions.assertFalse((boolean)TestFrameTest.this.gotSetupTest_);
                TestFrameTest.this.gotSetupTest_ = true;
                this.addResource("http://test.com/test.html", "<html><body>Test!</body></html>", "text/html");
                this.createBrowser("http://test.com/test.html");
                super.setupTest();
            }

            @Override
            protected void cleanupTest() {
                Assertions.assertFalse((boolean)TestFrameTest.this.gotCleanupTest_);
                TestFrameTest.this.gotCleanupTest_ = true;
                super.cleanupTest();
            }

            @Override
            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                if (!isLoading) {
                    Assertions.assertFalse((boolean)TestFrameTest.this.gotLoadingStateChange_);
                    TestFrameTest.this.gotLoadingStateChange_ = true;
                    this.terminateTest();
                }
            }
        };
        frame.awaitCompletion();
        Assertions.assertTrue((boolean)this.gotSetupTest_);
        Assertions.assertTrue((boolean)this.gotLoadingStateChange_);
        Assertions.assertTrue((boolean)this.gotCleanupTest_);
    }
}

