/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.EdgeIntersection;
import org.geotools.geometry.iso.topograph2D.GeometryGraph;
import org.geotools.geometry.iso.topograph2D.index.SegmentIntersector;
import org.geotools.geometry.iso.util.algorithm2D.RobustLineIntersector;

public class IsSimpleOp {
    public boolean isSimple(CurveImpl geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(SurfaceImpl geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    private boolean isSimpleLinearGeometry(GeometryImpl geom) {
        GeometryGraph graph = new GeometryGraph(0, geom);
        RobustLineIntersector li = new RobustLineIntersector();
        SegmentIntersector si = graph.computeSelfNodes(li, true);
        if (!si.hasIntersection()) {
            return true;
        }
        if (si.hasProperIntersection()) {
            return false;
        }
        if (this.hasNonEndpointIntersection(graph)) {
            return false;
        }
        return !this.hasClosedEndpointIntersection(graph);
    }

    private boolean hasNonEndpointIntersection(GeometryGraph graph) {
        Iterator i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            int maxSegmentIndex = e.getMaximumSegmentIndex();
            Iterator eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                if (ei.isEndPoint(maxSegmentIndex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasClosedEndpointIntersection(GeometryGraph graph) {
        TreeMap endPoints = new TreeMap();
        Iterator i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            int maxSegmentIndex = e.getMaximumSegmentIndex();
            boolean isClosed = e.isClosed();
            Coordinate p0 = e.getCoordinate(0);
            this.addEndpoint(endPoints, p0, isClosed);
            Coordinate p1 = e.getCoordinate(e.getNumPoints() - 1);
            this.addEndpoint(endPoints, p1, isClosed);
        }
        for (EndpointInfo eiInfo : endPoints.values()) {
            if (!eiInfo.isClosed || eiInfo.degree == 2) continue;
            return true;
        }
        return false;
    }

    private void addEndpoint(Map endPoints, Coordinate p, boolean isClosed) {
        EndpointInfo eiInfo = (EndpointInfo)endPoints.get(p);
        if (eiInfo == null) {
            eiInfo = new EndpointInfo(p);
            endPoints.put(p, eiInfo);
        }
        eiInfo.addEndpoint(isClosed);
    }

    class EndpointInfo {
        Coordinate pt;
        boolean isClosed;
        int degree;

        EndpointInfo(Coordinate pt) {
            this.pt = pt;
            this.isClosed = false;
            this.degree = 0;
        }

        void addEndpoint(boolean isClosed) {
            ++this.degree;
            this.isClosed |= isClosed;
        }
    }
}

