/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PBETest
implements Test {
    private Cipher makePBECipher(String string, int n, char[] cArray, byte[] byArray, int n2) throws Exception {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        Cipher cipher = Cipher.getInstance(string, "BC");
        cipher.init(n, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
        return cipher;
    }

    private boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        byte[] byArray = Hex.decode("1234567890abcdefabcdef1234567890fedbca098765");
        try {
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS7Padding", "BC");
            cipher.init(1, (Key)new SecretKeySpec(Hex.decode("30e69252758e5346"), "DES"), new IvParameterSpec(Hex.decode("7c1c1ab9c454a688")));
            byte[] byArray2 = cipher.doFinal(byArray);
            char[] cArray = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
            Cipher cipher2 = this.makePBECipher("PBEWithSHA1AndDES", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048);
            byte[] byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": DES failed");
            }
            cipher = Cipher.getInstance("DESede/CBC/PKCS7Padding", "BC");
            cipher.init(1, (Key)new SecretKeySpec(Hex.decode("732f2d33c801732b7206756cbd44f9c1c103ddd97c7cbe8e"), "DES"), new IvParameterSpec(Hex.decode("b07bf522c8d608b8")));
            byArray2 = cipher.doFinal(byArray);
            cipher2 = this.makePBECipher("PBEWithSHAAnd3-KeyTripleDES-CBC", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048);
            byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": DESede failed");
            }
            cipher = Cipher.getInstance("RC2/CBC/PKCS7Padding", "BC");
            cipher.init(1, (Key)new SecretKeySpec(Hex.decode("732f2d33c8"), "RC2"), new IvParameterSpec(Hex.decode("b07bf522c8d608b8")));
            byArray2 = cipher.doFinal(byArray);
            cipher2 = this.makePBECipher("PBEWithSHAAnd40BitRC2-CBC", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048);
            byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": RC2 failed");
            }
            cipher = Cipher.getInstance("RC4", "BC");
            cipher.init(1, new SecretKeySpec(Hex.decode("732f2d33c801732b7206756cbd44f9c1"), "RC4"));
            byArray2 = cipher.doFinal(byArray);
            cipher2 = this.makePBECipher("PBEWithSHAAnd128BitRC4", 2, cArray, Hex.decode("7d60435f02e9e0ae"), 2048);
            byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": RC4 failed");
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "PBETest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        PBETest pBETest = new PBETest();
        TestResult testResult = pBETest.perform();
        System.out.println(testResult.toString());
    }
}

