/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.netscape;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class NetscapeCertRequest
implements DEREncodable {
    AlgorithmIdentifier sigAlg;
    AlgorithmIdentifier keyAlg;
    byte[] sigBits;
    String challenge;
    DERBitString content;
    PublicKey pubkey;

    public NetscapeCertRequest(DERConstructedSequence dERConstructedSequence) {
        try {
            if (dERConstructedSequence.getSize() != 3) {
                throw new IllegalArgumentException("invalid SPKAC (size):" + dERConstructedSequence.getSize());
            }
            this.sigAlg = new AlgorithmIdentifier((DERConstructedSequence)dERConstructedSequence.getObjectAt(1));
            this.sigBits = ((DERBitString)dERConstructedSequence.getObjectAt(2)).getBytes();
            DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)dERConstructedSequence.getObjectAt(0);
            if (dERConstructedSequence2.getSize() != 2) {
                throw new IllegalArgumentException("invalid PKAC (len): " + dERConstructedSequence2.getSize());
            }
            this.challenge = ((DERIA5String)dERConstructedSequence2.getObjectAt(1)).getString();
            this.content = new DERBitString(dERConstructedSequence2);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((DERConstructedSequence)dERConstructedSequence2.getObjectAt(0));
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(new DERBitString(subjectPublicKeyInfo).getBytes());
            this.keyAlg = subjectPublicKeyInfo.getAlgorithmId();
            this.pubkey = KeyFactory.getInstance(this.keyAlg.getObjectId().getId(), "BC").generatePublic(x509EncodedKeySpec);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public NetscapeCertRequest(String string, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        this.challenge = string;
        this.sigAlg = algorithmIdentifier;
        this.pubkey = publicKey;
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.getKeySpec());
        dERConstructedSequence.addObject(new DERIA5String(string));
        this.content = new DERBitString(dERConstructedSequence);
    }

    public String getChallenge() {
        return this.challenge;
    }

    public void setChallenge(String string) {
        this.challenge = string;
    }

    public AlgorithmIdentifier getSigningAlgorithm() {
        return this.sigAlg;
    }

    public void setSigningAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.sigAlg = algorithmIdentifier;
    }

    public AlgorithmIdentifier getKeyAlgorithm() {
        return this.keyAlg;
    }

    public void setKeyAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.keyAlg = algorithmIdentifier;
    }

    public PublicKey getPublicKey() {
        return this.pubkey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.pubkey = publicKey;
    }

    public boolean verify(String string) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException {
        if (!string.equals(this.challenge)) {
            return false;
        }
        Signature signature = Signature.getInstance(this.sigAlg.getObjectId().getId(), "BC");
        signature.initVerify(this.pubkey);
        signature.update(this.content.getBytes());
        return signature.verify(this.sigBits);
    }

    public void sign(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException, InvalidKeySpecException {
        this.sign(privateKey, null);
    }

    public void sign(PrivateKey privateKey, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException, InvalidKeySpecException {
        Signature signature = Signature.getInstance(this.sigAlg.getObjectId().getId(), "BC");
        signature.initSign(privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.getKeySpec());
        dERConstructedSequence.addObject(new DERIA5String(this.challenge));
        try {
            dEROutputStream.writeObject(dERConstructedSequence);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new SignatureException(iOException.getMessage());
        }
        signature.update(byteArrayOutputStream.toByteArray());
        this.sigBits = signature.sign();
    }

    private DERObject getKeySpec() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERObject dERObject = null;
        try {
            byteArrayOutputStream.write(this.pubkey.getEncoded());
            ((OutputStream)byteArrayOutputStream).close();
            DERInputStream dERInputStream = new DERInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            dERObject = dERInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(iOException.getMessage());
        }
        return dERObject;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        DERConstructedSequence dERConstructedSequence2 = new DERConstructedSequence();
        try {
            dERConstructedSequence2.addObject(this.getKeySpec());
        }
        catch (Exception exception) {}
        dERConstructedSequence2.addObject(new DERIA5String(this.challenge));
        dERConstructedSequence.addObject(dERConstructedSequence2);
        dERConstructedSequence.addObject(this.sigAlg);
        dERConstructedSequence.addObject(new DERBitString(this.sigBits));
        return dERConstructedSequence;
    }
}

