/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

public class DSAParameter
implements DEREncodable {
    DERInteger p;
    DERInteger q;
    DERInteger g;

    public static DSAParameter getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DSAParameter.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DSAParameter getInstance(Object object) {
        if (object == null || object instanceof DSAParameter) {
            return (DSAParameter)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DSAParameter((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid DSAParameter: " + object.getClass().getName());
    }

    public DSAParameter(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new DERInteger(bigInteger);
        this.q = new DERInteger(bigInteger2);
        this.g = new DERInteger(bigInteger3);
    }

    public DSAParameter(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.p = (DERInteger)enumeration.nextElement();
        this.q = (DERInteger)enumeration.nextElement();
        this.g = (DERInteger)enumeration.nextElement();
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.p);
        dERConstructedSequence.addObject(this.q);
        dERConstructedSequence.addObject(this.g);
        return dERConstructedSequence;
    }
}

