/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class RC2CBCParameter
implements DEREncodable {
    DERInteger version;
    DEROctetString iv;

    public RC2CBCParameter(DERConstructedSequence dERConstructedSequence) {
        if (dERConstructedSequence.getSize() == 1) {
            this.version = null;
            this.iv = (DEROctetString)dERConstructedSequence.getObjectAt(0);
            return;
        }
        this.version = (DERInteger)dERConstructedSequence.getObjectAt(0);
        this.iv = (DEROctetString)dERConstructedSequence.getObjectAt(1);
    }

    public BigInteger getRC2ParameterVersion() {
        return this.version.getValue();
    }

    public byte[] getIV() {
        return this.iv.getOctets();
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        if (this.version != null) {
            dERConstructedSequence.addObject(this.version);
        }
        dERConstructedSequence.addObject(this.iv);
        return dERConstructedSequence;
    }
}

