/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class PKCS12PBEParams
implements DEREncodable {
    DERInteger iterations;
    DEROctetString iv;

    public PKCS12PBEParams(byte[] byArray, int n) {
        this.iv = new DEROctetString(byArray);
        this.iterations = new DERInteger(n);
    }

    public PKCS12PBEParams(ASN1Sequence aSN1Sequence) {
        this.iv = (DEROctetString)aSN1Sequence.getObjectAt(0);
        this.iterations = (DERInteger)aSN1Sequence.getObjectAt(1);
    }

    public static PKCS12PBEParams getInstance(Object object) {
        if (object instanceof PKCS12PBEParams) {
            return (PKCS12PBEParams)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PKCS12PBEParams((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public BigInteger getIterations() {
        return this.iterations.getValue();
    }

    public byte[] getIV() {
        return this.iv.getOctets();
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.iv);
        dERConstructedSequence.addObject(this.iterations);
        return dERConstructedSequence;
    }
}

