/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSObject;

public class UnauthAttributes
extends CMSObject {
    private ASN1Set attributes;

    public UnauthAttributes(Vector vector) {
        this.setAttributes(vector);
    }

    public UnauthAttributes(ASN1Set aSN1Set) {
        this.attributes = aSN1Set;
    }

    public UnauthAttributes(UnauthAttributes unauthAttributes) {
        this.attributes = unauthAttributes.attributes;
    }

    public static UnauthAttributes getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return UnauthAttributes.getInstance(ASN1Set.getInstance(aSN1TaggedObject, bl));
    }

    public static UnauthAttributes getInstance(Object object) {
        if (object == null || object instanceof UnauthAttributes) {
            return (UnauthAttributes)object;
        }
        if (object instanceof Vector) {
            return new UnauthAttributes((Vector)object);
        }
        if (object instanceof ASN1Set) {
            return new UnauthAttributes((ASN1Set)object);
        }
        throw new IllegalArgumentException("Invalid UnauthAttributes: " + object.getClass().getName());
    }

    public Vector getAttributes() {
        int n = this.attributes.getSize();
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(Attribute.getInstance(this.attributes.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        return this.attributes;
    }

    private void setAttributes(Vector vector) {
        int n = vector.size();
        this.attributes = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.attributes.addObject(Attribute.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

