/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class MessageAuthenticationCodeAlgorithm
extends CMSObject {
    private AlgorithmIdentifier alg;

    public MessageAuthenticationCodeAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public MessageAuthenticationCodeAlgorithm(ASN1Sequence aSN1Sequence) {
        this(new AlgorithmIdentifier(aSN1Sequence));
    }

    public MessageAuthenticationCodeAlgorithm(MessageAuthenticationCodeAlgorithm messageAuthenticationCodeAlgorithm) {
        this.alg = messageAuthenticationCodeAlgorithm.alg;
    }

    public MessageAuthenticationCodeAlgorithm(DERObjectIdentifier dERObjectIdentifier) {
        this(new AlgorithmIdentifier(dERObjectIdentifier));
    }

    public MessageAuthenticationCodeAlgorithm(String string) {
        this(new AlgorithmIdentifier(new DERObjectIdentifier(string)));
    }

    public MessageAuthenticationCodeAlgorithm(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this(new AlgorithmIdentifier(dERObjectIdentifier, dERObject));
    }

    public static MessageAuthenticationCodeAlgorithm getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new MessageAuthenticationCodeAlgorithm(AlgorithmIdentifier.getInstance(aSN1TaggedObject, bl));
    }

    public static MessageAuthenticationCodeAlgorithm getInstance(Object object) {
        if (object == null || object instanceof MessageAuthenticationCodeAlgorithm) {
            return (MessageAuthenticationCodeAlgorithm)object;
        }
        return new MessageAuthenticationCodeAlgorithm(AlgorithmIdentifier.getInstance(object));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }
}

