/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateKeySpec;

public class RSAMultiPrimePrivateCrtKeySpec
extends RSAPrivateKeySpec {
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private RSAOtherPrimeInfo[] otherPrimeInfo;

    public RSAMultiPrimePrivateCrtKeySpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, RSAOtherPrimeInfo[] rSAOtherPrimeInfoArray) {
        super(bigInteger, bigInteger3);
        if (bigInteger2 == null || bigInteger4 == null || bigInteger5 == null || bigInteger6 == null || bigInteger7 == null || bigInteger8 == null) {
            throw new NullPointerException("Invalid null argument");
        }
        if (rSAOtherPrimeInfoArray != null) {
            if (rSAOtherPrimeInfoArray.length == 0) {
                throw new IllegalArgumentException("Invalid length for otherPrimeInfo");
            }
            this.otherPrimeInfo = (RSAOtherPrimeInfo[])rSAOtherPrimeInfoArray.clone();
        }
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public RSAOtherPrimeInfo[] getOtherPrimeInfo() {
        if (this.otherPrimeInfo != null) {
            return (RSAOtherPrimeInfo[])this.otherPrimeInfo.clone();
        }
        return null;
    }
}

