/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class FileSelector
implements DiscoverySelector {
    private final String path;

    FileSelector(String path) {
        this.path = path;
    }

    public File getFile() {
        return new File(this.path);
    }

    public Path getPath() {
        return Paths.get(this.path, new String[0]);
    }

    public String getRawPath() {
        return this.path;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSelector that = (FileSelector)o;
        return Objects.equals(this.path, that.path);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("path", this.path).toString();
    }
}

