/*
 * Decompiled with CFR 0.152.
 */
package tests.junittests;

import java.util.concurrent.CountDownLatch;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import tests.junittests.TestSetupContext;

public class TestSetupExtension
implements BeforeAllCallback,
ExtensionContext.Store.CloseableResource {
    private static boolean initialized_ = false;
    private static CountDownLatch countdown_ = new CountDownLatch(1);

    public void beforeAll(ExtensionContext context) {
        if (!initialized_) {
            initialized_ = true;
            this.initialize(context);
        }
    }

    private void initialize(ExtensionContext context) {
        TestSetupContext.initialize(context);
        if (TestSetupContext.debugPrint()) {
            System.out.println("TestSetupExtension.initialize");
        }
        context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put((Object)"jcef_test_setup", (Object)this);
        if (!CefApp.startup(null)) {
            System.out.println("Startup initialization failed!");
            return;
        }
        CefApp.addAppHandler((CefAppHandler)new CefAppHandlerAdapter(null){

            public void stateHasChanged(CefApp.CefAppState state) {
                if (state == CefApp.CefAppState.TERMINATED) {
                    countdown_.countDown();
                }
            }
        });
        CefSettings settings = new CefSettings();
        CefApp.getInstance((CefSettings)settings);
    }

    public void close() {
        if (TestSetupContext.debugPrint()) {
            System.out.println("TestSetupExtension.close");
        }
        CefApp.getInstance().dispose();
        try {
            countdown_.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

