/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.elem2D;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.geotools.geometry.iso.util.algorithm2D.AlgoLine2D;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;
import org.geotools.geometry.iso.util.algorithm2D.AlgoRectangle2D;
import org.geotools.geometry.iso.util.algorithm2D.LineLineIntersection2D;
import org.geotools.geometry.iso.util.elem2D.Edge2D;
import org.geotools.geometry.iso.util.elem2D.Node2D;
import org.geotools.geometry.iso.util.elem2D.Simplex2D;

public class Triangle2D
extends Simplex2D {
    private static int[] SIDE = new int[]{3, 6, 5};

    public Triangle2D(Node2D p0, Node2D p1, Node2D p2) {
        super(new Node2D[]{p0, p1, p2});
    }

    @Override
    public int n() {
        return 3;
    }

    @Override
    public int sideBits(int s) {
        return SIDE[s];
    }

    public double getArea() {
        Node2D[] p = this.getPoints();
        return Math.abs(0.5 * ((((Point2D)p[0]).getX() - ((Point2D)p[1]).getX()) * (((Point2D)p[0]).getY() + ((Point2D)p[1]).getY()) + (((Point2D)p[1]).getX() - ((Point2D)p[2]).getX()) * (((Point2D)p[1]).getY() + ((Point2D)p[2]).getY()) + (((Point2D)p[2]).getX() - ((Point2D)p[0]).getX()) * (((Point2D)p[2]).getY() + ((Point2D)p[0]).getY())));
    }

    public void setSide(int s, Edge2D e) {
        this.linkEdge(s, e);
    }

    public void setSide(int s, Triangle2D f) {
        this.linkSimplex(s, f);
    }

    public int getSideNr(Point2D p0, Point2D p1) {
        int n = 0;
        n = this.getSide(p0, p1);
        return n;
    }

    public double getRadiusU() {
        Point2D[] pts = new Point2D[this.n()];
        pts = this.getPoints();
        Point2D p0 = new Point2D.Double();
        Point2D p1 = new Point2D.Double();
        Point2D p2 = new Point2D.Double();
        p0 = pts[0];
        p1 = pts[1];
        p2 = pts[2];
        Point2D.Double pm = new Point2D.Double(0.5 * p1.getX() + 0.5 * p0.getX(), 0.5 * p1.getY() + 0.5 * p0.getY());
        double c = Math.sqrt(((Point2D)pm).getX() * ((Point2D)pm).getX() - 2.0 * (((Point2D)pm).getX() * p2.getX()) + p2.getX() * p2.getX() + ((Point2D)pm).getY() * ((Point2D)pm).getY() - 2.0 * (((Point2D)pm).getY() * p2.getY()) + p2.getY() * p2.getY());
        double l = 2.0 * Math.sqrt(((Point2D)pm).getX() * ((Point2D)pm).getX() - 2.0 * (((Point2D)pm).getX() * p0.getX()) + p0.getX() * p0.getX() + ((Point2D)pm).getY() * ((Point2D)pm).getY() - 2.0 * (((Point2D)pm).getY() * p0.getY()) + p0.getY() * p0.getY());
        Point2D p0_1 = AlgoPoint2D.subtract(p0, pm);
        Point2D p1_1 = AlgoPoint2D.subtract(p1, pm);
        Point2D p2_1 = AlgoPoint2D.subtract(p2, pm);
        Point2D.Double p0_2 = new Point2D.Double(-0.5 * l, 0.0);
        Point2D.Double p1_2 = new Point2D.Double(0.5 * l, 0.0);
        double angle = Math.acos(p0_1.getX() * ((Point2D)p0_2).getX() / (Math.sqrt(Math.pow(p0_1.getX(), 2.0) + Math.pow(p0_1.getY(), 2.0)) * Math.sqrt(((Point2D)p0_2).getX() * ((Point2D)p0_2).getX())));
        if (p1_1.getY() > 0.0) {
            angle = Math.PI * 2 - angle;
        }
        Point2D.Double p2_2 = new Point2D.Double(Math.cos(angle) * (p2.getX() - ((Point2D)pm).getX()) - Math.sin(angle) * (p2.getY() - ((Point2D)pm).getY()), Math.sin(angle) * (p2.getX() - ((Point2D)pm).getX()) + Math.cos(angle) * (p2.getY() - ((Point2D)pm).getY()));
        double b = 1.0 / (2.0 * ((Point2D)p2_2).getY()) * (c * c - l * l / 4.0);
        return Math.sqrt(4.0 * (b * b) + l * l) / 2.0;
    }

    public double getRadiusI() {
        Node2D[] p = this.getPoints();
        double p0x = ((Point2D)p[0]).getX();
        double p0y = ((Point2D)p[0]).getY();
        double p1x = ((Point2D)p[1]).getX();
        double p1y = ((Point2D)p[1]).getY();
        double p2x = ((Point2D)p[2]).getX();
        double p2y = ((Point2D)p[2]).getY();
        double umfang = Math.sqrt(p0x * p0x - 2.0 * p0x * p1x + p1x * p1x + p0y * p0y - 2.0 * p0y * p1y + p1y * p1y) + Math.sqrt(p1x * p1x - 2.0 * p1x * p2x + p2x * p2x + p1y * p1y - 2.0 * p1y * p2y + p2y * p2y) + Math.sqrt(p2x * p2x - 2.0 * p2x * p0x + p0x * p0x + p2y * p2y - 2.0 * p2y * p0y + p0y * p0y);
        return this.getArea() / (umfang * 0.5);
    }

    public double getQuality() {
        return this.getRadiusI() / this.getRadiusU();
    }

    public boolean containsPoints(Point2D[] p) {
        int n = p.length;
        for (int i = 0; i < n; ++i) {
            if (!this.containsPoint(p[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint(Point2D p) {
        for (int i = 0; i < 3; ++i) {
            if (p.equals(this.point[i])) {
                return false;
            }
            if (!AlgoLine2D.rightSide(this.point[i], this.point[(i + 1) % 3], p)) continue;
            return false;
        }
        return true;
    }

    private boolean validPatch(Line2D[] lineA, Line2D[] lineB) {
        int nA = lineA.length;
        int nB = lineB.length;
        LineLineIntersection2D intsc = new LineLineIntersection2D();
        for (int iA = 0; iA < nA; ++iA) {
            for (int iB = 0; iB < nB; ++iB) {
                intsc.setValues(lineA[iA], lineB[iB]);
                if (intsc.isCoincident() || !intsc.isBI() && !intsc.isIB()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean intersects(Triangle2D other) {
        if (!AlgoRectangle2D.intersects(this.getRectangle(), other.getRectangle())) {
            return false;
        }
        int nA = 3;
        int nB = 3;
        Line2D[] lineA = new Line2D[nA];
        Line2D[] lineB = new Line2D[nB];
        for (int iA = 0; iA < nA; ++iA) {
            lineA[iA] = new Line2D.Double(this.point[iA], this.point[(iA + 1) % nA]);
        }
        for (int iB = 0; iB < nB; ++iB) {
            lineB[iB] = new Line2D.Double(other.point[iB], other.point[(iB + 1) % nB]);
        }
        if (!this.validPatch(lineA, lineB) || !this.validPatch(lineB, lineA)) {
            return true;
        }
        if (this.containsPoints(other.point)) {
            return true;
        }
        return other.containsPoints(this.point);
    }
}

