/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.primitive;

import java.util.HashSet;
import java.util.Set;
import org.geotools.geometry.iso.complex.ComplexImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.complex.Composite;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.PrimitiveBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class PrimitiveImpl
extends GeometryImpl
implements Primitive {
    protected Set<Primitive> containedPrimitive = null;
    protected Set<Primitive> containingPrimitive = null;
    protected Set<Complex> complex = null;

    protected PrimitiveImpl(CoordinateReferenceSystem crs, Set<Primitive> containedPrimitive, Set<Primitive> containingPrimitive, Set<Complex> complex) {
        super(crs);
        this.containedPrimitive = containedPrimitive;
        this.containingPrimitive = containingPrimitive;
        this.complex = complex;
    }

    public PrimitiveImpl(CoordinateReferenceSystem coordinateReferenceSystem) {
        super(coordinateReferenceSystem);
    }

    public Set<Primitive> getContainingPrimitives() {
        return this.containingPrimitive;
    }

    public Set<Primitive> getContainedPrimitives() {
        return this.containedPrimitive;
    }

    public Set<Complex> getComplexes() {
        return this.complex;
    }

    public Composite getComposite() {
        return null;
    }

    public void addContainingPrimitive(PrimitiveImpl newSubelement) {
        if (this.containingPrimitive == null) {
            this.containingPrimitive = new HashSet<Primitive>();
        }
        this.containingPrimitive.add(newSubelement);
    }

    public void addContainedPrimitive(PrimitiveImpl newSuperelement) {
        if (this.containedPrimitive == null) {
            this.containedPrimitive = new HashSet<Primitive>();
        }
        this.containedPrimitive.add(newSuperelement);
    }

    public void addComplex(ComplexImpl newComplex) {
        if (this.complex == null) {
            this.complex = new HashSet<Complex>();
        }
        this.complex.add(newComplex);
    }

    public Set<Complex> getMaximalComplex() {
        if (this.complex == null) {
            return null;
        }
        HashSet<Complex> result = new HashSet<Complex>();
        for (Complex c : this.complex) {
            result.addAll(c.getMaximalComplex());
        }
        return result;
    }

    public abstract PrimitiveBoundary getBoundary();

    public abstract OrientablePrimitive[] getProxy();
}

