/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.io.Serializable;
import org.geotools.geometry.iso.DimensionModel;
import org.geotools.geometry.iso.UnsupportedDimensionException;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.util.algorithmND.AlgoRectangleND;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnvelopeImpl
implements Envelope,
Serializable {
    private static final long serialVersionUID = -6397319034308589090L;
    static final int X = 0;
    static final int Y = 1;
    static final int Z = 2;
    private DirectPosition pMin = null;
    private DirectPosition pMax = null;
    private PositionFactory factory;

    public EnvelopeImpl(Envelope env) {
        this.pMin = new DirectPositionImpl(env.getLowerCorner());
        this.pMax = new DirectPositionImpl(env.getUpperCorner());
    }

    public EnvelopeImpl(DirectPosition p0, DirectPosition p1) {
        this.setValues(p0, p1);
    }

    public EnvelopeImpl(Position position) {
        this(position.getDirectPosition());
    }

    public EnvelopeImpl(DirectPosition position) {
        this.pMin = new DirectPositionImpl(position);
        this.pMax = new DirectPositionImpl(position);
    }

    public int getDimension() {
        return this.pMin.getDimension();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.pMin.getCoordinateReferenceSystem();
    }

    public double getMinimum(int dimension) {
        return this.pMin.getOrdinate(dimension);
    }

    public double getMaximum(int dimension) {
        return this.pMax.getOrdinate(dimension);
    }

    public double getCenter(int dimension) {
        return (this.pMax.getOrdinate(dimension) - this.pMin.getOrdinate(dimension)) / 2.0;
    }

    public double getMedian(int dimension) {
        return (this.pMax.getOrdinate(dimension) - this.pMin.getOrdinate(dimension)) / 2.0;
    }

    public double getLength(int dimension) {
        return this.pMax.getOrdinate(dimension) - this.pMin.getOrdinate(dimension);
    }

    public double getSpan(int dimension) {
        return this.pMax.getOrdinate(dimension) - this.pMin.getOrdinate(dimension);
    }

    public DirectPosition getUpperCorner() {
        return this.pMax;
    }

    public DirectPosition getLowerCorner() {
        return this.pMin;
    }

    public void setValues(DirectPosition p0, DirectPosition p1) {
        if (p0 == null || p1 == null || p0.getDimension() != p1.getDimension()) {
            throw new IllegalArgumentException("Error 1 on setValues");
        }
        CoordinateReferenceSystem crs = p0.getCoordinateReferenceSystem();
        double[] min = p0.getCoordinate();
        double[] max = p1.getCoordinate();
        int n = p0.getDimension();
        for (int i = 0; i < n; ++i) {
            if (!(min[i] > max[i])) continue;
            double tmp = min[i];
            min[i] = max[i];
            max[i] = tmp;
        }
        this.pMin = new DirectPositionImpl(crs, min);
        this.pMax = new DirectPositionImpl(crs, max);
    }

    public void setValues(EnvelopeImpl env) {
        this.pMin = new DirectPositionImpl(env.getLowerCorner());
        this.pMax = new DirectPositionImpl(env.getUpperCorner());
    }

    public static EnvelopeImpl createEnvelope(DirectPosition[] p) {
        if (p.length == 0) {
            return null;
        }
        EnvelopeImpl result = new EnvelopeImpl(p[0]);
        for (int i = 1; i < p.length; ++i) {
            if (p[i] == null) continue;
            result.add(p[i]);
        }
        return result;
    }

    public void expand(Envelope env) {
        this.expand(env.getLowerCorner().getCoordinate());
        this.expand(env.getUpperCorner().getCoordinate());
    }

    public void expand(double[] coord) {
        int n = Math.min(this.getDimension(), coord.length);
        double[] min = this.pMin.getCoordinate();
        double[] max = this.pMax.getCoordinate();
        for (int i = 0; i < n; ++i) {
            if (coord[i] < min[i]) {
                this.pMin.setOrdinate(i, coord[i]);
            }
            if (!(coord[i] > max[i])) continue;
            this.pMax.setOrdinate(i, coord[i]);
        }
    }

    public String toString() {
        return "[Envelope: " + this.getLowerCorner() + " - " + this.getUpperCorner() + "]";
    }

    public void add(double[] coord) {
        assert (coord.length == this.getDimension());
        double[] minCoord = this.pMin.getCoordinate();
        double[] maxCoord = this.pMax.getCoordinate();
        for (int i = 0; i < this.getDimension(); ++i) {
            double ci = coord[i];
            double cmini = minCoord[i];
            double cmaxi = maxCoord[i];
            if (!Double.isNaN(ci) && (ci < cmini || Double.isNaN(cmini))) {
                this.pMin.setOrdinate(i, ci);
            }
            if (Double.isNaN(ci) || !(ci > cmaxi) && !Double.isNaN(cmaxi)) continue;
            this.pMax.setOrdinate(i, ci);
        }
    }

    public void add(DirectPosition p) {
        this.add(p.getCoordinate());
    }

    public void add(EnvelopeImpl env) {
        this.add(env.getLowerCorner());
        this.add(env.getUpperCorner());
    }

    public boolean equals(Envelope env) {
        return this.getUpperCorner().equals((Object)env.getUpperCorner()) && this.getLowerCorner().equals((Object)env.getLowerCorner());
    }

    public boolean intersects(Envelope other) {
        return AlgoRectangleND.intersects(this.pMin.getCoordinate(), this.pMax.getCoordinate(), other.getLowerCorner().getCoordinate(), other.getUpperCorner().getCoordinate());
    }

    public boolean intersects(DirectPosition dp) {
        return AlgoRectangleND.contains(this.pMin.getCoordinate(), this.pMax.getCoordinate(), dp.getCoordinate());
    }

    public DirectPosition getNECorner() {
        return this.getUpperCorner();
    }

    public DirectPosition getSWCorner() {
        return this.getLowerCorner();
    }

    public DirectPosition getSECorner() throws UnsupportedDimensionException {
        DirectPositionImpl rDP = null;
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        int D = DimensionModel.toD(this.getCoordinateReferenceSystem());
        if (D == 1) {
            rDP = new DirectPositionImpl(crs, new double[]{this.pMax.getOrdinate(0), this.pMin.getOrdinate(1)});
        } else if (D == 2) {
            rDP = new DirectPositionImpl(crs, new double[]{this.pMax.getOrdinate(0), this.pMin.getOrdinate(1), this.pMin.getOrdinate(2)});
        } else {
            throw new UnsupportedDimensionException("3d not supported.");
        }
        return rDP;
    }

    public DirectPositionImpl getNWCornerOld() throws UnsupportedDimensionException {
        DirectPositionImpl rDP = null;
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        int D = DimensionModel.toD(crs);
        if (D == 1) {
            rDP = new DirectPositionImpl(crs, new double[]{this.pMin.getOrdinate(0), this.pMax.getOrdinate(1)});
        } else if (D == 2) {
            rDP = new DirectPositionImpl(crs, new double[]{this.pMin.getOrdinate(0), this.pMax.getOrdinate(1), this.pMin.getOrdinate(2)});
        } else {
            throw new UnsupportedDimensionException("3d not supported.");
        }
        return rDP;
    }

    public DirectPositionImpl getNWCorner() throws UnsupportedDimensionException {
        DirectPositionImpl rDP = null;
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        int D = DimensionModel.toD(crs);
        if (D == 1) {
            rDP = new DirectPositionImpl(crs, new double[]{this.pMin.getOrdinate(0), this.pMax.getOrdinate(1)});
        } else if (D == 2) {
            rDP = new DirectPositionImpl(crs, new double[]{this.pMin.getOrdinate(0), this.pMax.getOrdinate(1), this.pMin.getOrdinate(2)});
        } else {
            throw new UnsupportedDimensionException("3d not supported.");
        }
        return rDP;
    }

    public boolean contains(DirectPosition p) {
        return AlgoRectangleND.contains(this.pMin.getCoordinate(), this.pMax.getCoordinate(), p.getCoordinate());
    }
}

