/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.io.Serializable;
import java.util.Arrays;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.geotools.geometry.iso.util.algorithmND.AlgoPointND;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class DirectPositionImpl
implements DirectPosition,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2327211794986364062L;
    private double[] coordinate;
    private CoordinateReferenceSystem crs;

    public DirectPositionImpl(CoordinateReferenceSystem crs) {
        int N = crs.getCoordinateSystem().getDimension();
        this.crs = crs;
        this.coordinate = new double[N];
        for (int i = 0; i < N; ++i) {
            this.coordinate[i] = Double.NaN;
        }
    }

    public DirectPositionImpl(CoordinateReferenceSystem crs, double[] coord) {
        this.crs = crs;
        assert (coord.length == crs.getCoordinateSystem().getDimension());
        this.coordinate = coord;
    }

    public DirectPositionImpl(Position position) {
        this(position.getDirectPosition());
    }

    public DirectPositionImpl(DirectPosition position) {
        this.crs = position.getCoordinateReferenceSystem();
        this.coordinate = position.getCoordinate();
    }

    public DirectPositionImpl(CoordinateReferenceSystem crs, double x, double y, double z) {
        this.crs = crs;
        assert (3 == crs.getCoordinateSystem().getDimension());
        this.coordinate = new double[]{x, y, z};
    }

    public DirectPositionImpl(CoordinateReferenceSystem crs, double x, double y, double z, double m) {
        this.crs = crs;
        assert (5 == crs.getCoordinateSystem().getDimension());
        this.coordinate = new double[]{x, y, z, m};
    }

    public int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    public double[] getCoordinate() {
        return (double[])this.coordinate.clone();
    }

    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.coordinate[dimension];
    }

    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        if (dimension >= this.coordinate.length || dimension < 0) {
            throw new IndexOutOfBoundsException("Index " + dimension + " out of coordinate range (max " + this.coordinate.length + ")");
        }
        this.coordinate[dimension] = value;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public DirectPositionImpl clone() {
        return new DirectPositionImpl(this.crs, (double[])this.coordinate.clone());
    }

    public void setCoordinate(double[] coord) {
        if (coord.length != this.getDimension()) {
            throw new IllegalArgumentException("Index " + coord.length + " out of coordinate range (expected " + this.getDimension() + ")");
        }
        this.coordinate = coord;
    }

    public double getX() {
        return this.coordinate[0];
    }

    public double getY() {
        return this.coordinate[1];
    }

    public double getZ() {
        return this.getDimension() > 2 ? this.coordinate[2] : Double.NaN;
    }

    public void setX(double x) {
        this.coordinate[0] = x;
    }

    public void setY(double y) {
        this.coordinate[1] = y;
    }

    public void setZ(double z) {
        if (this.getDimension() > 2) {
            this.coordinate[2] = z;
        }
    }

    public boolean equals(DirectPosition position, double tol) {
        int D = position.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        if (D != this.crs.getCoordinateSystem().getDimension()) {
            return false;
        }
        if (!CRS.equalsIgnoreMetadata((Object)this.getCoordinateReferenceSystem(), (Object)position.getCoordinateReferenceSystem())) {
            return false;
        }
        for (int i = 0; i < D; ++i) {
            if (Double.isNaN(position.getOrdinate(i)) && Double.isNaN(this.coordinate[i]) || !(Math.abs(DoubleOperation.subtract(position.getOrdinate(i), this.coordinate[i])) > tol)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof DirectPosition) {
            return this.equals((DirectPosition)o, 0.0);
        }
        if (o instanceof Position) {
            return ((Position)o).equals(this);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coordinate);
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        return result;
    }

    public String toString() {
        double[] coord = this.getCoordinate();
        String str = "(" + Double.toString(coord[0]);
        for (int i = 1; i < coord.length; ++i) {
            str = str + " " + Double.toString(coord[i]);
        }
        return str + ")";
    }

    public double distance(DirectPosition p) {
        return AlgoPointND.getDistance(this.coordinate, p.getCoordinate());
    }

    public double distanceSquare(DirectPosition p) {
        return AlgoPointND.getDistanceSquare(this.coordinate, p.getCoordinate());
    }

    public void add(double[] values) {
        if (this.coordinate.length != values.length) {
            throw new MismatchedDimensionException();
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            this.coordinate[i] = Double.compare(this.coordinate[i], Double.NaN) == 0 ? values[i] : DoubleOperation.add(this.coordinate[i], values[i]);
        }
    }

    public void add(DirectPositionImpl otherDP) {
        if (this.coordinate.length != otherDP.getDimension()) {
            throw new MismatchedDimensionException();
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            this.coordinate[i] = Double.compare(this.coordinate[i], Double.NaN) == 0 ? otherDP.getOrdinate(i) : DoubleOperation.add(this.coordinate[i], otherDP.getOrdinate(i));
        }
    }

    public void scale(double factor) {
        for (int i = 0; i < this.coordinate.length; ++i) {
            this.coordinate[i] = DoubleOperation.mult(this.coordinate[i], factor);
        }
    }

    public void divideBy(double factor) {
        for (int i = 0; i < this.coordinate.length; ++i) {
            this.coordinate[i] = DoubleOperation.div(this.coordinate[i], factor);
        }
    }

    public DirectPosition getDirectPosition() {
        return this;
    }
}

