/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CertStoreTest
implements Test {
    public TestResult perform() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
            X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
            X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
            X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
            ArrayList arrayList = new ArrayList();
            arrayList.add(x509Certificate);
            arrayList.add(x509Certificate2);
            arrayList.add(x509Certificate3);
            arrayList.add(x509CRL);
            arrayList.add(x509CRL2);
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
            CertStore certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x509Certificate.getSubjectDN().getName());
            Collection collection = certStore.getCertificates(x509CertSelector);
            if (collection.size() != 1 || !collection.contains(x509Certificate)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": rootCert not found by subjectDN");
            }
            x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x509Certificate.getSubjectDN().getName());
            x509CertSelector.setSubject(x509CertSelector.getSubjectAsBytes());
            collection = certStore.getCertificates(x509CertSelector);
            if (collection.size() != 1 || !collection.contains(x509Certificate)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": rootCert not found by encoded subjectDN");
            }
            x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubjectPublicKey(x509Certificate.getPublicKey().getEncoded());
            collection = certStore.getCertificates(x509CertSelector);
            if (collection.size() != 1 || !collection.contains(x509Certificate)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": rootCert not found by encoded public key");
            }
            x509CertSelector = new X509CertSelector();
            x509CertSelector.setIssuer(x509Certificate.getSubjectDN().getName());
            collection = certStore.getCertificates(x509CertSelector);
            if (collection.size() != 2) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": did not found 2 certs");
            }
            if (!collection.contains(x509Certificate)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": rootCert not found");
            }
            if (!collection.contains(x509Certificate2)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": interCert not found");
            }
            X509CRLSelector x509CRLSelector = new X509CRLSelector();
            x509CRLSelector.addIssuerName(x509CRL.getIssuerDN().getName());
            Collection collection2 = certStore.getCRLs(x509CRLSelector);
            if (collection2.size() != 1 || !collection2.contains(x509CRL)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": rootCrl not found");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    public String getName() {
        return "CertStore";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        CertStoreTest certStoreTest = new CertStoreTest();
        TestResult testResult = certStoreTest.perform();
        System.out.println(testResult.toString());
    }
}

