/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.JCERSAPrivateKey;

public class JCERSAPrivateCrtKey
extends JCERSAPrivateKey
implements RSAPrivateCrtKey {
    private BigInteger publicExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;

    JCERSAPrivateCrtKey(RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters) {
        super(rSAPrivateCrtKeyParameters);
        this.publicExponent = rSAPrivateCrtKeyParameters.getPublicExponent();
        this.primeP = rSAPrivateCrtKeyParameters.getP();
        this.primeQ = rSAPrivateCrtKeyParameters.getQ();
        this.primeExponentP = rSAPrivateCrtKeyParameters.getDP();
        this.primeExponentQ = rSAPrivateCrtKeyParameters.getDQ();
        this.crtCoefficient = rSAPrivateCrtKeyParameters.getQInv();
    }

    JCERSAPrivateCrtKey(RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) {
        this.modulus = rSAPrivateCrtKeySpec.getModulus();
        this.publicExponent = rSAPrivateCrtKeySpec.getPublicExponent();
        this.privateExponent = rSAPrivateCrtKeySpec.getPrivateExponent();
        this.primeP = rSAPrivateCrtKeySpec.getPrimeP();
        this.primeQ = rSAPrivateCrtKeySpec.getPrimeQ();
        this.primeExponentP = rSAPrivateCrtKeySpec.getPrimeExponentP();
        this.primeExponentQ = rSAPrivateCrtKeySpec.getPrimeExponentQ();
        this.crtCoefficient = rSAPrivateCrtKeySpec.getCrtCoefficient();
    }

    JCERSAPrivateCrtKey(RSAPrivateCrtKey rSAPrivateCrtKey) {
        this.modulus = rSAPrivateCrtKey.getModulus();
        this.publicExponent = rSAPrivateCrtKey.getPublicExponent();
        this.privateExponent = rSAPrivateCrtKey.getPrivateExponent();
        this.primeP = rSAPrivateCrtKey.getPrimeP();
        this.primeQ = rSAPrivateCrtKey.getPrimeQ();
        this.primeExponentP = rSAPrivateCrtKey.getPrimeExponentP();
        this.primeExponentQ = rSAPrivateCrtKey.getPrimeExponentQ();
        this.crtCoefficient = rSAPrivateCrtKey.getCrtCoefficient();
    }

    JCERSAPrivateCrtKey(PrivateKeyInfo privateKeyInfo) {
        this(new RSAPrivateKeyStructure((DERConstructedSequence)privateKeyInfo.getPrivateKey()));
    }

    JCERSAPrivateCrtKey(RSAPrivateKeyStructure rSAPrivateKeyStructure) {
        this.modulus = rSAPrivateKeyStructure.getModulus();
        this.publicExponent = rSAPrivateKeyStructure.getPublicExponent();
        this.privateExponent = rSAPrivateKeyStructure.getPrivateExponent();
        this.primeP = rSAPrivateKeyStructure.getPrime1();
        this.primeQ = rSAPrivateKeyStructure.getPrime2();
        this.primeExponentP = rSAPrivateKeyStructure.getExponent1();
        this.primeExponentQ = rSAPrivateKeyStructure.getExponent2();
        this.crtCoefficient = rSAPrivateKeyStructure.getCoefficient();
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null), new RSAPrivateKeyStructure(this.getModulus(), this.getPublicExponent(), this.getPrivateExponent(), this.getPrimeP(), this.getPrimeQ(), this.getPrimeExponentP(), this.getPrimeExponentQ(), this.getCrtCoefficient()).getDERObject());
        try {
            dEROutputStream.writeObject(privateKeyInfo);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding RSA public key");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RSAPrivateCrtKey)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)object;
        return this.getModulus().equals(rSAPrivateCrtKey.getModulus()) && this.getPublicExponent().equals(rSAPrivateCrtKey.getPublicExponent()) && this.getPrivateExponent().equals(rSAPrivateCrtKey.getPrivateExponent()) && this.getPrimeP().equals(rSAPrivateCrtKey.getPrimeP()) && this.getPrimeQ().equals(rSAPrivateCrtKey.getPrimeQ()) && this.getPrimeExponentP().equals(rSAPrivateCrtKey.getPrimeExponentP()) && this.getPrimeExponentQ().equals(rSAPrivateCrtKey.getPrimeExponentQ()) && this.getCrtCoefficient().equals(rSAPrivateCrtKey.getCrtCoefficient());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("RSA Private CRT Key" + string);
        stringBuffer.append("            modulus: " + this.getModulus().toString(16) + string);
        stringBuffer.append("    public exponent: " + this.getPublicExponent().toString(16) + string);
        stringBuffer.append("   private exponent: " + this.getPrivateExponent().toString(16) + string);
        stringBuffer.append("             primeP: " + this.getPrimeP().toString(16) + string);
        stringBuffer.append("             primeQ: " + this.getPrimeQ().toString(16) + string);
        stringBuffer.append("     primeExponentP: " + this.getPrimeExponentP().toString(16) + string);
        stringBuffer.append("     primeExponentQ: " + this.getPrimeExponentQ().toString(16) + string);
        stringBuffer.append("     crtCoefficient: " + this.getCrtCoefficient().toString(16) + string);
        return stringBuffer.toString();
    }
}

