/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x9.X9FieldElement;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECCurve;

public class X9Curve
implements DEREncodable,
X9ObjectIdentifiers {
    private ECCurve curve;
    private byte[] seed;

    public X9Curve(ECCurve eCCurve) {
        this.curve = eCCurve;
        this.seed = null;
    }

    public X9Curve(ECCurve eCCurve, byte[] byArray) {
        this.curve = eCCurve;
        this.seed = byArray;
    }

    public X9Curve(X9FieldID x9FieldID, DERConstructedSequence dERConstructedSequence) {
        if (!x9FieldID.getIdentifier().equals(X9ObjectIdentifiers.prime_field)) {
            throw new RuntimeException("not implemented");
        }
        BigInteger bigInteger = ((DERInteger)x9FieldID.getParameters()).getValue();
        X9FieldElement x9FieldElement = new X9FieldElement(true, bigInteger, (DEROctetString)dERConstructedSequence.getObjectAt(0));
        X9FieldElement x9FieldElement2 = new X9FieldElement(true, bigInteger, (DEROctetString)dERConstructedSequence.getObjectAt(1));
        this.curve = new ECCurve.Fp(bigInteger, x9FieldElement.getValue().toBigInteger(), x9FieldElement2.getValue().toBigInteger());
        if (dERConstructedSequence.getSize() == 3) {
            this.seed = ((DERBitString)dERConstructedSequence.getObjectAt(2)).getBytes();
        }
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(new X9FieldElement(this.curve.getA()).getDERObject());
        dERConstructedSequence.addObject(new X9FieldElement(this.curve.getB()).getDERObject());
        if (this.seed != null) {
            dERConstructedSequence.addObject(new DERBitString(this.seed));
        }
        return dERConstructedSequence;
    }
}

