/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

public class RSAPublicKeyStructure
implements DEREncodable {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public static RSAPublicKeyStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RSAPublicKeyStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RSAPublicKeyStructure getInstance(Object object) {
        if (object == null || object instanceof RSAPublicKeyStructure) {
            return (RSAPublicKeyStructure)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RSAPublicKeyStructure((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid RSAPublicKeyStructure: " + object.getClass().getName());
    }

    public RSAPublicKeyStructure(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
    }

    public RSAPublicKeyStructure(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.modulus = ((DERInteger)enumeration.nextElement()).getValue();
        this.publicExponent = ((DERInteger)enumeration.nextElement()).getValue();
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(new DERInteger(this.getModulus()));
        dERConstructedSequence.addObject(new DERInteger(this.getPublicExponent()));
        return dERConstructedSequence;
    }
}

