/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;

public class AlgorithmIdentifier
implements DEREncodable {
    private DERObjectIdentifier objectId;
    private DEREncodable parameters;
    private boolean parametersDefined = false;

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AlgorithmIdentifier getInstance(Object object) {
        if (object instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)object;
        }
        if (object instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof String) {
            return new AlgorithmIdentifier((String)object);
        }
        if (object instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this.objectId = dERObjectIdentifier;
    }

    public AlgorithmIdentifier(String string) {
        this.objectId = new DERObjectIdentifier(string);
    }

    public AlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.parametersDefined = true;
        this.objectId = dERObjectIdentifier;
        this.parameters = dEREncodable;
    }

    public AlgorithmIdentifier(ASN1Sequence aSN1Sequence) {
        this.objectId = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.getSize() == 2) {
            this.parametersDefined = true;
            this.parameters = aSN1Sequence.getObjectAt(1);
            return;
        }
        this.parameters = null;
    }

    public DERObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public DEREncodable getParameters() {
        return this.parameters;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.objectId);
        if (this.parametersDefined) {
            dERConstructedSequence.addObject(this.parameters);
        }
        return dERConstructedSequence;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AlgorithmIdentifier)) {
            return false;
        }
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)object;
        if (!this.getObjectId().equals(algorithmIdentifier.getObjectId())) {
            return false;
        }
        if (this.getParameters() == null && algorithmIdentifier.getParameters() == null) {
            return true;
        }
        if (this.getParameters() == null || algorithmIdentifier.getParameters() == null) {
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream2);
        try {
            dEROutputStream.writeObject(this.getParameters());
            dEROutputStream2.writeObject(algorithmIdentifier.getParameters());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n != byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

