/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;

public class RecipientIdentifier
extends CMSObject {
    public DEREncodable id;

    public RecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setId(issuerAndSerialNumber);
    }

    public RecipientIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.setId(subjectKeyIdentifier);
    }

    public RecipientIdentifier(DERObject dERObject) {
        if (dERObject instanceof ASN1TaggedObject) {
            this.id = SubjectKeyIdentifier.getInstance((ASN1TaggedObject)dERObject, false);
            return;
        }
        this.id = IssuerAndSerialNumber.getInstance(dERObject);
    }

    public RecipientIdentifier(RecipientIdentifier recipientIdentifier) {
        this.id = recipientIdentifier.id;
    }

    public static RecipientIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RecipientIdentifier.getInstance(aSN1TaggedObject);
    }

    public static RecipientIdentifier getInstance(Object object) {
        if (object == null || object instanceof RecipientIdentifier) {
            return (RecipientIdentifier)object;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new RecipientIdentifier((IssuerAndSerialNumber)object);
        }
        if (object instanceof SubjectKeyIdentifier) {
            return new RecipientIdentifier((SubjectKeyIdentifier)object);
        }
        if (object instanceof DERObject) {
            return new RecipientIdentifier((DERObject)object);
        }
        throw new IllegalArgumentException("Invalid RecipientIdentifier: " + object.getClass().getName());
    }

    public DEREncodable getId() {
        return this.id;
    }

    private void setId(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.id = subjectKeyIdentifier;
    }

    public DERObject getDERObject() {
        if (this.id instanceof IssuerAndSerialNumber) {
            return this.id.getDERObject();
        }
        return new BERTaggedObject(0, this.id.getDERObject());
    }

    private void setId(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }
}

