/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;

public class RecipientEncryptedKeys
extends CMSObject {
    private Vector keys;

    public RecipientEncryptedKeys(Vector vector) {
        this.setKeys(vector);
    }

    public RecipientEncryptedKeys(ASN1Sequence aSN1Sequence) {
        this.keys = new Vector();
        int n = aSN1Sequence.getSize();
        int n2 = 0;
        while (n2 < n) {
            this.keys.addElement(RecipientEncryptedKey.getInstance(aSN1Sequence.getObjectAt(n2)));
            ++n2;
        }
    }

    public RecipientEncryptedKeys(RecipientEncryptedKeys recipientEncryptedKeys) {
        this.keys = recipientEncryptedKeys.keys;
    }

    public static RecipientEncryptedKeys getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RecipientEncryptedKeys.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RecipientEncryptedKeys getInstance(Object object) {
        if (object == null || object instanceof RecipientEncryptedKeys) {
            return (RecipientEncryptedKeys)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RecipientEncryptedKeys((ASN1Sequence)object);
        }
        if (object instanceof Vector) {
            return new RecipientEncryptedKeys((Vector)object);
        }
        throw new IllegalArgumentException("Invalid RecipientEncryptedKeys: " + object.getClass().getName());
    }

    public Vector getKeys() {
        return this.keys;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        int n = this.keys.size();
        int n2 = 0;
        while (n2 < n) {
            bERConstructedSequence.addObject((RecipientEncryptedKey)this.keys.elementAt(n2));
            ++n2;
        }
        return bERConstructedSequence;
    }

    private void setKeys(Vector vector) {
        this.keys = vector;
    }
}

