/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeValue;
import org.bouncycastle.asn1.cms.CMSObject;

public class Attribute
extends CMSObject {
    protected DERObjectIdentifier attrType;
    protected ASN1Set attrValues;

    protected Attribute() {
    }

    public Attribute(String string, Vector vector) {
        this.setAttrType(string);
        this.setAttrValues(vector);
    }

    public Attribute(ASN1Sequence aSN1Sequence) {
        this.attrType = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.attrValues = (DERConstructedSet)aSN1Sequence.getObjectAt(1);
    }

    public Attribute(Attribute attribute) {
        this.attrType = attribute.attrType;
        this.attrValues = attribute.attrValues;
    }

    protected Attribute(DERObjectIdentifier dERObjectIdentifier, ASN1Set aSN1Set) {
        this.attrType = dERObjectIdentifier;
        this.attrValues = aSN1Set;
    }

    public static Attribute getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return Attribute.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Attribute getInstance(Object object) {
        if (object == null || object instanceof Attribute) {
            return (Attribute)object;
        }
        if (object instanceof ASN1Sequence) {
            return new Attribute((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid Attribute: " + object.getClass().getName());
    }

    public String getAttrType() {
        return this.attrType.getId();
    }

    public ASN1Set getAttrValuesDERSet() {
        return this.attrValues;
    }

    public Vector getAttrValues() {
        int n = this.attrValues.getSize();
        Vector<AttributeValue> vector = new Vector<AttributeValue>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(AttributeValue.getInstance(this.attrValues.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.attrType);
        bERConstructedSequence.addObject(this.attrValues);
        return bERConstructedSequence;
    }

    private void setAttrType(String string) {
        this.attrType = new DERObjectIdentifier(string);
    }

    private void setAttrValues(Vector vector) {
        int n = vector.size();
        this.attrValues = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.attrValues.addObject(AttributeValue.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

