/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertUtil;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CertificateFactory {
    private CertificateFactorySpi certFacSpi;
    private Provider provider;
    private String type;

    protected CertificateFactory(CertificateFactorySpi certificateFactorySpi, Provider provider, String string) {
        this.certFacSpi = certificateFactorySpi;
        this.provider = provider;
        this.type = string;
    }

    public final CRL generateCRL(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(inputStream);
    }

    public final Collection generateCRLs(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(inputStream);
    }

    public final Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(inputStream);
    }

    public final Collection generateCertificates(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(inputStream);
    }

    public final Iterator getCertPathEncodings() {
        return this.certFacSpi.engineGetCertPathEncodings();
    }

    public final CertPath generateCertPath(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(inputStream);
    }

    public final CertPath generateCertPath(InputStream inputStream, String string) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(inputStream, string);
    }

    public final CertPath generateCertPath(List list) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(list);
    }

    public static final CertificateFactory getInstance(String string) throws CertificateException {
        try {
            CertUtil.Implementation implementation = CertUtil.getImplementation("CertificateFactory", string, null);
            if (implementation != null) {
                return new CertificateFactory((CertificateFactorySpi)implementation.getEngine(), implementation.getProvider(), string);
            }
            throw new CertificateException("can't find type " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CertificateException(String.valueOf(string) + " not found");
        }
    }

    public static final CertificateFactory getInstance(String string, String string2) throws CertificateException, NoSuchProviderException {
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertificateFactory", string, string2);
        if (implementation != null) {
            return new CertificateFactory((CertificateFactorySpi)implementation.getEngine(), implementation.getProvider(), string);
        }
        throw new CertificateException("can't find type " + string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }
}

