/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;

public class CertPathValidatorException
extends GeneralSecurityException {
    private Throwable cause;
    private CertPath certPath;
    private int index = -1;

    public CertPathValidatorException() {
    }

    public CertPathValidatorException(String string) {
        super(string);
    }

    public CertPathValidatorException(String string, Throwable throwable) {
        super(string);
        this.cause = throwable;
    }

    public CertPathValidatorException(String string, Throwable throwable, CertPath certPath, int n) {
        super(string);
        if (certPath == null && n != -1) {
            throw new IllegalArgumentException("certPath = null and index != -1");
        }
        if (n < -1 || certPath != null && n >= certPath.getCertificates().size()) {
            throw new IndexOutOfBoundsException(" index < -1 or out of bound of certPath.getCertificates()");
        }
        this.cause = throwable;
        this.certPath = certPath;
        this.index = n;
    }

    public CertPathValidatorException(Throwable throwable) {
        this.cause = throwable;
    }

    public String getMessage() {
        String string = super.getMessage();
        if (string == null && this.cause == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(String.valueOf(string) + "\n");
        }
        if (this.cause != null) {
            stringBuffer.append("Cause:\n" + this.cause.getMessage() + "\n");
        }
        return stringBuffer.toString();
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getIndex() {
        return this.index;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getMessage();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (this.getIndex() >= 0) {
            stringBuffer.append("index in certpath: " + this.getIndex() + "\n");
            stringBuffer.append(this.getCertPath());
        }
        return stringBuffer.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.getCause() != null) {
            this.getCause().printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.getCause() != null) {
            this.getCause().printStackTrace(printWriter);
        }
    }
}

